﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Store all of the Test Result Data that is common across both the Pathology and Diagnostic Imaging. 
    /// </summary>
    public class TestResult
    {
        /// <summary>
        /// The Test Result Name.
        /// </summary>
        public TestResultName PrimaryName { get; set; }
        
        /// <summary>
        /// The Alternate Test Result Names.
        /// </summary>
        public TestResultName[] AlternateNames { get; set; }
        
        /// <summary>
        /// The Overall Test Result Status HL7® Code.
        /// </summary>
        public string Status { get; set; }
        
        /// <summary>
        /// The date and time the test result was completed.
        /// </summary>        
        public DateTime ObservationDateTime { get; set; }
        
        /// <summary>
        /// Any custom text in the test result details.
        /// </summary>
        public string NarrativeText { get; set; }
    }
}
