﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.CommonSchemas.Exceptions
{
    /// <summary>
    /// This exception is thrown when the Hpii lookup fails for a reason
    /// unrelated to data quality, such as when the Medicare service is
    /// temporarily unavailable. The application support team should see
    /// the message, so an "ERROR" message is written to the log.
    ///
    /// The HL7 message broker will fail the next message. A negative acknowlegdement
    /// will be returned and the message can not be retried until the HPI-I alert is resolved.
    /// </summary>
    public class HpiiErrorException : Exception
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="IhiErrorException"/> class.
        /// </summary>
        /// <param name="textMessage">The error message text.</param>
        public HpiiErrorException(string textMessage)
            : base(textMessage)
        {
        }
    }
}
