﻿using System;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace HIPS.IhiSchemas.Schemas
{
    /// <summary>
    /// This class represents the response from an IHI search.
    /// </summary>
    /// <remarks>This can not have the Serializable attribute as it overrides the XMLSerializer formatter</remarks>
    [KnownType(typeof(IhiSearchResponse))]
    [DataContract]
    public class IhiSearchResponse
    {
        #region Private Fields

        private string firstName;
        private HipsResponse hipsResponse = new HipsResponse(HipsResponseIndicator.OK);
        private string ihi;
        private IhiRecordStatus ihiRecordStatus;
        private IhiStatus ihiStatus;
        private string lastName;
        private DateTime? lastValidatedDate;
        private string sexCode;
        private string sexDescription;

        #endregion Private Fields

        #region properties

        /// <summary>
        /// Gets or sets the Medicare registered first name.
        /// </summary>
        /// <value>
        /// The first name.
        /// </value>
        [DataMember]
        public string FirstName
        {
            get
            {
                return firstName;
            }
            set
            {
                firstName = value;
            }
        }

        /// <summary>
        /// Gets or sets the IHI Lookup Return Status.
        /// </summary>
        /// <value>
        /// The IHI Lookup Return Status.
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get
            {
                return hipsResponse;
            }
            set
            {
                hipsResponse = value;
            }
        }

        /// <summary>
        /// Gets or sets the validated IHI.
        /// </summary>
        /// <value>
        /// The ihi.
        /// </value>
        [DataMember]
        public string Ihi
        {
            get
            {
                return ihi;
            }
            set
            {
                ihi = value;
            }
        }

        /// <summary>
        /// Gets or sets the date when the IHI was last validated.
        /// </summary>
        /// <value>
        /// The date when the IHI was last validated.
        /// </value>
        [DataMember]
        public DateTime? IhiLastValidated
        {
            get
            {
                return lastValidatedDate;
            }
            set
            {
                lastValidatedDate = value;
            }
        }

        /// <summary>
        /// Gets or sets the IHI Record Status.
        /// </summary>
        /// <value>
        /// The ihi Record status.
        /// </value>
        [DataMember]
        public IhiRecordStatus IhiRecordStatus
        {
            get
            {
                return ihiRecordStatus;
            }
            set
            {
                ihiRecordStatus = value;
            }
        }

        /// <summary>
        /// Gets or sets the IHI Status.
        /// </summary>
        /// <value>
        /// The ihi status.
        /// </value>
        [DataMember]
        public IhiStatus IhiStatus
        {
            get
            {
                return ihiStatus;
            }
            set
            {
                ihiStatus = value;
            }
        }

        /// <summary>
        /// Gets or sets the Medicare registered last name.
        /// </summary>
        /// <value>
        /// The last name.
        /// </value>
        [DataMember]
        public string LastName
        {
            get
            {
                return lastName;
            }
            set
            {
                lastName = value;
            }
        }

        /// <summary>
        /// Gets or sets the Medicare registered sex code.
        /// </summary>
        /// <value>
        /// The sex code.
        /// </value>
        [DataMember]
        public string SexCode
        {
            get
            {
                return sexCode;
            }
            set
            {
                sexCode = value;
            }
        }

        /// <summary>
        /// Gets or sets the Medicare registered sex description.
        /// </summary>
        /// <value>
        /// The sex description.
        /// </value>
        [DataMember]
        public string SexDescription
        {
            get
            {
                return sexDescription;
            }
            set
            {
                sexDescription = value;
            }
        }

        #endregion properties
    }
}