﻿using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;

namespace HIPS.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the ConsentAudit table.
    /// </summary>
    public class ConsentAuditDl : BaseDl
    {
        #region Constructors

        public ConsentAuditDl(UserDetails user)
            : base(user)
        {
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Inserts the specified consent audit record.
        /// </summary>
        /// <param name="ConsentAudit">The consent audit record.</param>
        /// <returns>Whether the consent audit record was inserted.</returns>
        public bool Insert(ConsentAudit ConsentAudit)
        {
            using (SqlCommand command = GetSqlCommand("hips.ConsentAuditInsert"))
            {
                return base.Insert<ConsentAudit>(ConsentAudit, command);
            }
        }

        #endregion Methods
    }
}