﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a EpisodeType
    /// </summary>
    [KnownType(typeof(EpisodeType))]
    [Serializable]
    [DataContract]
    public class EpisodeType : BaseCodeListSchema
    {
        /// <summary>
        /// Gets or sets the EpisodeType id.
        /// </summary>
        /// <value>
        /// The EpisodeType id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int? EpisodeTypeId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
    }
}