﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a received HL7 message, and allows the message to be retried later when some condition changes
    /// For example if the patient has not yet been registered through PAS, the processing of pathology messages is deferred
    /// by storing the messages in the database via this class.
    /// </summary>
    [KnownType(typeof(HL7MessageLog))]
    [Serializable]
    [DataContract]
    public class HL7MessageLog : BaseSchema
    {
        /// <summary>
        /// Gets or sets the date and time of the message.
        /// </summary>
        /// <value>
        /// The date and time of the message.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public DateTime? DateTimeOfMessage { get; set; }

        /// <summary>
        /// Gets or sets the failure reason.
        /// </summary>
        /// <value>
        /// The failure reason.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string FailureReason { get; set; }

        /// <summary>
        /// Gets or sets the full message.
        /// </summary>
        /// <value>
        /// The full message.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string FullMessage { get; set; }

        /// <summary>
        /// Gets or sets the message id.
        /// </summary>
        /// <value>
        /// The message id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.AutoGeneratedKey)]
        public int? HL7MessageLogId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }

        /// <summary>
        /// Gets or sets the hospital.
        /// </summary>
        /// <value>
        /// The hospital.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int? HospitalID { get; set; }

        /// <summary>
        /// Gets or sets the hospital patient identifier. This may not yet exist in the HospitalPatient class.
        /// </summary>
        /// <value>
        /// The hospital patient identifier (Mrn).
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HospitalPatientIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the message control id.
        /// </summary>
        /// <value>
        /// The message control id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string MessageControlId { get; set; }

        /// <summary>
        /// Gets or sets the queue status id.
        /// </summary>
        /// <value>
        /// The queue status id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int QueueStatusId { get; set; }

        /// <summary>
        /// Gets or sets the retry count.
        /// </summary>
        /// <value>
        /// The retry count.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int RetryCount { get; set; }

        /// <summary>
        /// Gets or sets the sending application.
        /// </summary>
        /// <value>
        /// The sending application.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string SendingApplication { get; set; }

        /// <summary>
        /// Gets or sets the sending facility.
        /// </summary>
        /// <value>
        /// The sending facility.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string SendingFacility { get; set; }

        /// <summary>
        /// Gets or sets whether the message should be retried.
        /// </summary>
        /// <value>
        /// Whether the message should be retried.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public bool ShouldRetry { get; set; }
    }
}