﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a Health Care Provider 
    /// </summary>
    [Serializable]
    public class HealthCareProvider : BaseCodeListSchema
    {

        /// <summary>
        /// Gets or sets the health care provider id.
        /// </summary>
        /// <value>
        /// The health care provider id.
        /// </value>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int? HealthCareProviderID
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
        /// <summary>
        /// Gets or sets the hpii.
        /// </summary>
        /// <value>
        /// The hpii.
        /// </value>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HpiI { get; set; }
        /// <summary>
        /// Gets or sets the title id.
        /// </summary>
        /// <value>
        /// The title id.
        /// </value>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int TitleID { get; set; }
        /// <summary>
        /// Gets or sets the title code.
        /// </summary>
        /// <value>
        /// The title code.
        /// </value>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string TitleCode { get; set; }
        /// <summary>
        /// Gets or sets the title description.
        /// </summary>
        /// <value>
        /// The title description.
        /// </value>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string TitleDescription { get; set; }
        /// <summary>
        /// Gets or sets the name of the family.
        /// </summary>
        /// <value>
        /// The name of the family.
        /// </value>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string FamilyName { get; set; }
        /// <summary>
        /// Gets or sets the name of the family.
        /// </summary>
        /// <value>
        /// The name of the family.
        /// </value>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string GivenNames { get; set; }
        /// <summary>
        /// Gets or sets the suffix id.
        /// </summary>
        /// <value>
        /// The suffix id.
        /// </value>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int? SuffixID { get; set; }
        /// <summary>
        /// Gets or sets the hospital code.
        /// </summary>
        /// <value>
        /// The hospital code.
        /// </value>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HospitalCode { get; set; }
        /// <summary>
        /// Gets or sets the doctor provider code.
        /// </summary>
        /// <value>
        /// The doctor provider code.
        /// </value>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string HealthcareProviderCode { get; set; }
        /// <summary>
        /// Gets or sets the suffix.
        /// </summary>
        /// <value>
        /// The suffix.
        /// </value>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string SuffixCode { get; set; }
        /// <summary>
        /// Gets or sets the suffix description.
        /// </summary>
        /// <value>
        /// The suffix description.
        /// </value>
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string SuffixDescription { get; set; }

        /// <summary>
        /// Gets the full name.
        /// </summary>
        public string FullName
        {
            get
            {
                return this.ToString();
            }
        }
        /// <summary>
        /// Returns a <see cref="System.String"/> that represents this instance.
        /// </summary>
        /// <returns>
        /// A <see cref="System.String"/> that represents this instance.
        /// </returns>
        public override string ToString()
       {
           StringBuilder builder = new StringBuilder();
            AddString(builder, this.TitleDescription);
            AddString(builder, this.GivenNames);
            AddString(builder, this.FamilyName);
            AddString(builder, this.SuffixDescription);
            return builder.ToString().Trim();
       }

        private void AddString(StringBuilder builder, string text)
        {
            if (!string.IsNullOrEmpty(text))
            {
                builder.Append(string.Format("{0} ", text));
            }
        }
    }
}
