﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a health provider individual hpii.
    /// </summary>
    [KnownType(typeof(HealthProviderIndividualHpii))]
    [Serializable]
    [DataContract]
    public class HealthProviderIndividualHpii : BaseSchema
    {
         #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="HealthProviderIndividualHpii" /> class.
        /// </summary>
        public HealthProviderIndividualHpii()
        {
           
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the health provider individual id.
        /// </summary>
        /// <value>
        /// The health provider individual id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int? HealthProviderIndividualId { get; set; }

        /// <summary>
        /// Gets or sets the HealthProviderOrganisationNetwork Id.
        /// </summary>
        /// <value>
        /// The HealthProviderOrganisationNetworkId.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int HealthProviderOrganisationNetworkId { get; set; }

        /// <summary>
        /// Gets or sets the hpii.
        /// </summary>
        /// <value>
        /// The hpii.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public string Hpii { get; set; }

        /// <summary>
        /// Gets or sets the hpii last validated date.
        /// </summary>
        /// <value>
        /// The hpii last validated date.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public DateTime? HpiiLastValidatedDate { get; set; }

        /// <summary>
        /// Gets or sets the HpiiStatus Id.
        /// </summary>
        /// <value>
        /// The HpiiStatusId.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int HpiiStatusId { get; set; }

        #endregion Properties
    }
}
