﻿using System;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace HIPS.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents an IHI Lookup Alert
    /// </summary>
    [KnownType(typeof(IhiLookupAlert))]
    [Serializable]
    [DataContract]
    public class IhiLookupAlert : BaseSchema
    {
        #region Private Members

        private int ihiLookupErrorId;
        private string message;
        private int patientMasterId;
        private string request;
        private string response;

        #endregion Private Members

        #region Contructors

        /// <summary>
        /// Initialises a new instance of the <see cref="IhiLookupAlert" /> class.
        /// </summary>
        public IhiLookupAlert()
        {
        }

        /// <summary>
        /// Initialises a new instance of the <see cref="IhiLookupAlert"/> class.
        /// </summary>
        /// <param name="patientMasterId">The patient master id.</param>
        /// <param name="message">The message.</param>
        /// <param name="request">The request.</param>
        /// <param name="response">The response.</param>
        public IhiLookupAlert(int patientMasterId, string message, string request, string response)
        {
            this.patientMasterId = patientMasterId;
            this.message = message;
            this.request = request;
            this.response = response;
        }

        #endregion Contructors

        #region Properties

        /// <summary>
        /// Gets or sets the error id.
        /// </summary>
        /// <value>
        /// The error id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.AutoGeneratedKey)]
        public int IhiLookupAlertId
        {
            get
            {
                return this.ihiLookupErrorId;
            }
            set
            {
                this.ihiLookupErrorId = value;
            }
        }

        /// <summary>
        /// Gets or sets the message.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.Data)]
        public string Message
        {
            get
            {
                return this.message;
            }
            set
            {
                this.message = value;
            }
        }

        /// <summary>
        /// Gets or sets the patient master id.
        /// </summary>
        /// <value>
        /// The patient master id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.Data)]
        public int PatientMasterId
        {
            get
            {
                return this.patientMasterId;
            }
            set
            {
                this.patientMasterId = value;
            }
        }

        /// <summary>
        /// Gets or sets the request sent to the IHI lookup service.
        /// </summary>
        /// <value>
        /// The request.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string Request
        {
            get
            {
                return this.request;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    this.request = value.Replace(@"encoding=""UTF-8""", @"encoding=""UTF-16""");
                }
                else
                {
                    this.request = value;
                }
            }
        }

        /// <summary>
        /// Gets or sets the response.
        /// </summary>
        /// <value>
        /// The response.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string Response
        {
            get
            {
                return this.response;
            }
            set
            {
                if (!string.IsNullOrEmpty(value))
                {
                    this.response = value.Replace(@"encoding=""UTF-8""", @"encoding=""UTF-16""");
                }
                else
                {
                    this.response = value;
                }
            }
        }

        #endregion Properties
    }
}