﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// The Queued Acknowledgement Operation
    /// </summary>
    public class QueuedAcknowledgementOperation
    {
        /// <summary>
        /// The message control ID of the acknowledgement (MSH-10).
        /// </summary>
        public string MessageControlID { get; set; }

        /// <summary>
        /// The message control ID of the original message being acknowledged (MSA-2).
        /// </summary>
        public string OriginalMessageControlId { get; set; }

        /// <summary>
        /// The full acknowledgement message encoded with HL7v2 rules.
        /// </summary>
        public string AcknowledgementMessage { get; set; }

        /// <summary>
        /// The acknowledgement code (MSA-1), for example AA for accept or AE for error.
        /// </summary>
        public string AcknowledgementCode { get; set; }

        /// <summary>
        /// The error condition code (MSA-6.1).
        /// </summary>
        public string ErrorConditionCode { get; set; }

        /// <summary>
        /// The error condition text (MSA-6.2).
        /// </summary>
        public string ErrorConditionText { get; set; }
    }
}
