﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using HIPS.CommonSchemas;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// This object is used to return the view and possible list of attachments from the PCEHR system.
    /// </summary>

    [KnownType(typeof(ViewResponse))]
    [Serializable]
    [DataContract]
    public class ViewResponse
    {
        #region Private Members

        private IList<Attachment> attachments = new List<Attachment>();
        private byte[] document;
        private string fileName;
        private HipsResponse hipsResponse;
        private string mimeType;
        private string templateId;

        #endregion Private Members

        #region Properties

        /// <summary>
        /// Gets or sets the Attachments
        /// </summary>
        /// <value>
        /// The attachments
        /// </value>
        [DataMember]
        public IList<Attachment> Attachments
        {
            get { return attachments; }
            set { attachments = value; }
        }

        /// <summary>
        /// Gets or sets the Document
        /// </summary>
        /// <value>
        /// The document
        /// </value>
        [DataMember]
        public byte[] Document
        {
            get { return document; }
            set { document = value; }
        }

        /// <summary>
        /// Gets or sets the FileName
        /// </summary>
        /// <value>
        /// The fileName
        /// </value>
        [DataMember]
        public String FileName
        {
            get { return fileName; }
            set { fileName = value; }
        }

        /// <summary>
        /// Gets or sets the HipsResponse, which contains information about success, warnings or failure.
        /// </summary>
        /// <value>
        /// The HipsResponse
        /// </value>
        [DataMember]
        public HipsResponse HipsResponse
        {
            get { return hipsResponse; }
            set { hipsResponse = value; }
        }

        /// <summary>
        /// Gets or sets the MimeType
        /// </summary>
        /// <value>
        /// The mimeType
        /// </value>
        [DataMember]
        public String MimeType
        {
            get { return mimeType; }
            set { mimeType = value; }
        }

        /// <summary>
        /// Gets or sets the DocumentUniqueId
        /// </summary>
        /// <value>
        /// The documentUniqueID
        /// </value>
        [DataMember]
        public String TemplateId
        {
            get { return templateId; }
            set { templateId = value; }
        }

        #endregion Properties
    }
}