﻿using System.ServiceModel;
using HIPS.ServiceContracts.Common.Fault;
using HIPS.ServiceContracts.Pcehr.Message;
using HIPS.ServiceContracts.AckQueue.Message;

namespace HIPS.ServiceContracts.AckQueue
{
    /// <summary>
    /// Interface for the AckQueue MSMQ queue.
    /// </summary>
    [ServiceContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.ACK_V1)]
    public interface IAckQueue
    {
        /// <summary>
        /// This operation is triggered by the Ack Queue MSMQ when there is a 
        /// SendAckRequest ready to process. It stores the acknowledgment in the logs 
        /// and if the MLLP is set up for responses sends the acknowledgment to the MLLP interface for forwarding.
        /// </summary>
        /// <param name="request">The request containing the acknowledgement to be processed.</param>
        [OperationContract(IsOneWay = true)]
        void SendAck(SendAckQueueRequest request);
    }
}
