﻿using System.ServiceModel;
using HIPS.ServiceContracts.Common.Fault;
using HIPS.ServiceContracts.Pcehr.Message;
using HIPS.ServiceContracts.AckQueue.Message;
using System.Threading.Tasks;

namespace HIPS.ServiceContracts.AckQueue
{
    /// <summary>
    /// Web service interface for the Ack service.
    /// Contains methods used to interact with the MSMQ Ack Queue
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.ACK_V1)]
    public interface IAckService
    {
        /// <summary>
        /// This operation is invoked by the Ack Queue when there is a SendAckRequest ready to process. 
        /// The implementation within eHISC application server is a simple implementation that merely stores the acknowledgement into a file. 
        /// When the MLLP interface is configured, the Ack Queue instead invokes the implementation of this service in Mirth®. 
        /// The implementation in Mirth® sends the acknowledgement to the configured MLLP endpoint.
        /// </summary>
        /// <param name="request">SendAck Request</param>
        [OperationContract]
        SendAckResponse SendAck(SendAckRequest request);
    }
}
