﻿using System.Runtime.Serialization;
using HIPS.ServiceContracts.Common.DTO.PatientIdentifier;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// CDA Document Details DTO. This object represents details about a
    /// clinical document that has been created by HIPS.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class CdaDocumentDetails
    {
        /// <summary>
        /// Gets or sets the CDA document.
        /// </summary>
        [DataMember(IsRequired = true)]
        public CdaDocument Document { get; set; }

        /// <summary>
        /// Gets or sets the document identifier used when creating the CDA document.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string DocumentId { get; set; }

        /// <summary>
        /// Gets or sets the document set identifier used when creating the CDA document.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string DocumentSetId { get; set; }

        /// <summary>
        /// Gets or sets the MRN number of the patient at the hospital that is
        /// specified in the patient identifier. If the MRN was auto-generated
        /// by HIPS then that value (which is based on a GUID) will be returned,
        /// otherwise it will be the MRN that was passed in the HL7 message to
        /// the Database Loader.
        /// </summary>
        [DataMember(IsRequired = true)]
        public string Mrn { get; set; }

        /// <summary>
        /// Gets or sets a patient identifier of the same type that was specified in the request.
        /// </summary>
        [DataMember(IsRequired = true)]
        public PatientIdentifierBase PatientIdentifier { get; set; }
    }
}