﻿using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.DTO
{
    /// <summary>
    /// CDA Attachment DTO.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public class CdaPackage
    {
        /// <summary>
        /// Gets or sets the binary content.
        /// </summary>
        [DataMember(IsRequired = true)]
        public byte[] Content { get; set; }

        /// <summary>
        /// Gets or sets the package format.
        /// </summary>
        [DataMember(IsRequired = true)]
        public CdaPackageFormat Format { get; set; }
    }
}
