﻿using System;
using System.Runtime.Serialization;

namespace HIPS.ServiceContracts.Common.DTO.ParticipatingIndividual
{
    /// <summary>
    /// Participating Provider DTO. This object contains information that identifies the
    /// person who is the 'Author', 'Legal Authenticator' and/or 'Responsible Health
    /// Professional at time of discharge' for the document.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    [KnownType(typeof(ParticipatingIndividual))]
    public class ParticipatingConsumer : ParticipatingIndividual
    {
        #region Properties

        /// <summary>
        /// Gets or sets the person's date of birth.
        /// </summary>
        [DataMember(IsRequired = false)]
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the person's IHI.
        /// </summary>
        [DataMember(IsRequired = false)]
        public string Ihi { get; set; }

        /// <summary>
        /// Gets or sets a code representing the person's sex.
        /// </summary>
        [DataMember(IsRequired = false)]
        public string Sex { get; set; }

        #endregion
    }
}
