﻿using System.Collections.Generic;
using System.ServiceModel;

namespace HIPS.ServiceContracts.Common.Message
{
    /// <summary>
    /// Abstract base class for all response messages associated with service operations.
    /// </summary>
    [MessageContract(WrapperNamespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.COMMON_V1)]
    public abstract class ResponseBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="ResponseBase" /> class.
        /// </summary>
        public ResponseBase()
        {
            this.Messages = new List<Common.DTO.Message>();
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the set of messages associated with the response.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        public virtual List<Common.DTO.Message> Messages { get; set; }

        /// <summary>
        /// Gets or sets a value representing the status of the response.
        /// </summary>
        [MessageBodyMember(Order = 1)]
        public virtual ResponseStatus Status { get; set; }

        #endregion Properties
    }
}