﻿using System.Runtime.Serialization;
using HIPS.ServiceContracts.Common;
using HIPS.ServiceContracts.Common.DTO;
using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;
using System;
using System.Collections.Generic;

namespace HIPS.ServiceContracts.Hpii.DTO
{
    /// <summary>
    /// HPI-I Batch Search Result DTO. This object is a normal search result,
    /// with an additional Request Identifier to allow the caller to correlate
    /// each result with the queries submitted in the original batch request.
    /// </summary>
    [DataContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.HPII_V2)]
    public class BatchSearchResult : SearchResult
    {
        #region Properties

        /// <summary>
        /// Gets or sets the request identifier.
        /// </summary>
        [DataMember(IsRequired = true)]
        [EntLibVal.Validators.StringLengthValidator(1, 36)]
        public string RequestIdentifier { get; set; }

        #endregion Properties
    }
}