﻿using System.ServiceModel;
using HIPS.ServiceContracts.Common.Fault;
using HIPS.ServiceContracts.Hpii.Message;

namespace HIPS.ServiceContracts.Hpii
{
    /// <summary>
    /// Web service interface for the HPI-I service version 2.
    /// Contains methods for searching and validating of healthcare provider individuals using the Healthcare Identifier Service.
    /// The storing and updating of Health Provider Details including HPI-I in the Local PCEHR Data Store
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.HPII_V2)]
    public interface IHpiiServiceV2
    {
        /// <summary>
        /// This operation retrieves the results of a batch of HPI-I searches from the HI Service.
        /// </summary>
        /// <param name="request">HpiiBatchRetrieveRequest request parameters.</param>
        /// <returns>Response including the results of the batch.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        HpiiBatchRetrieveResponse HpiiBatchRetrieve(HpiiBatchRetrieveRequest request);

        /// <summary>
        /// This operation submits a batch of HPI-I searches to the HI Service.
        /// </summary>
        /// <param name="request">HpiiBatchSubmitRequest request parameters.</param>
        /// <returns>Response including the batch identifier.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        HpiiBatchSubmitResponse HpiiBatchSubmit(HpiiBatchSubmitRequest request);

        /// <summary>
        /// This operation submits an HPI-I demographic search to the HI Service.
        /// </summary>
        /// <param name="request">HpiiDemographicSearchRequest request parameters.</param>
        /// <returns>Response including the search results.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        HpiiDemographicSearchResponse HpiiDemographicSearch(HpiiDemographicSearchRequest request);

        /// <summary>
        /// This operation submits an HPI-I identifier search to the HI Service.
        /// </summary>
        /// <param name="request">HpiiIdentifierSearchRequest request parameters.</param>
        /// <returns>Response including the search results.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(HiServiceFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        HpiiIdentifierSearchResponse HpiiIdentifierSearch(HpiiIdentifierSearchRequest request);

        /// <summary>
        /// List all of the current local providers for the specified facility.
        /// </summary>
        /// <param name="request">List Local Provider request parameters.</param>
        /// <returns>List Local Provider response.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        ListLocalProviderResponse ListLocalProviders(ListLocalProviderRequest request);

        /// <summary>
        /// Add or Edit a Local Provider.
        /// </summary>
        /// <param name="request">Add or Edit Local Provider request.</param>
        /// <returns>Add or Edit Local Provider response.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        AddEditLocalProviderResponse AddEditLocalProvider(AddEditLocalProviderRequest request);

        /// <summary>
        /// Add or Replace a Local Provider Identifier.
        /// </summary>
        /// <param name="request">Add or Replace Local Provider Identifier request.</param>
        /// <returns>Add or Replace Local Provider Identifier response.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        AddReplaceLocalProviderIdentifierResponse AddReplaceLocalProviderIdentifier(AddReplaceLocalProviderIdentifierRequest request);

        /// <summary>
        /// Deactivates or removes deactivation a local provider.
        /// </summary>
        /// <param name="request">Deactivate Local Provider request parameters.</param>
        /// <returns>Deactivate Local Provider response.</returns>
        [OperationContract]
        [FaultContract(typeof(InvalidRequestFault))]
        [FaultContract(typeof(ServiceOperationFault))]
        [FaultContract(typeof(InvalidUserFault))]
        [FaultContract(typeof(ItemNotFoundFault))]
        DeactivateLocalProviderResponse DeactivateLocalProvider(DeactivateLocalProviderRequest request);
    }
}