﻿using System.Collections.Generic;
using System.ServiceModel;
using HIPS.ServiceContracts.Common.DTO;
using HIPS.ServiceContracts.Common.Message;
using HIPS.ServiceContracts.Hpii.DTO;
using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Hpii.Message
{
    /// <summary>
    /// Web service request message for the HPI-I Batch Submit operation.
    /// </summary>
    [ServiceKnownType(typeof(RequestBase))]
    public class HpiiBatchSubmitRequest : RequestBase
    {
        /// <summary>
        /// Gets or sets the Hospital Code and Hospital Code System of the facility whose
        /// healthcare provider organisation is the organisation responsible for the
        /// HPI-I search.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        [EntLibVal.Validators.NotNullValidator]
        public HospitalIdentifier Facility { get; set; }

        /// <summary>
        /// Gets or sets the list of HPI-I demographic queries.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        [EntLibVal.Validators.ObjectCollectionValidator]
        public List<DemographicQuery> DemographicQueries { get; set; }

        /// <summary>
        /// Gets or sets the list of HPI-I identifier queries.
        /// </summary>
        [MessageBodyMember(Order = 4)]
        [EntLibVal.Validators.ObjectCollectionValidator]
        public List<IdentifierQuery> IdentifierQueries { get; set; }
    }
}