﻿using System.Collections.Generic;
using System.ServiceModel;
using HIPS.ServiceContracts.Common.DTO;
using HIPS.ServiceContracts.Common.Message;
using HIPS.ServiceContracts.Hpii.DTO;
using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Hpii.Message
{
    /// <summary>
    /// Web service request message for the HPI-I Demographic Search operation.
    /// </summary>
    [ServiceKnownType(typeof(RequestBase))]
    public class HpiiDemographicSearchRequest : RequestBase
    {
        /// <summary>
        /// Gets or sets the Hospital Code and Hospital Code System of the facility whose
        /// healthcare provider organisation is the organisation responsible for the
        /// HPI-I search.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        [EntLibVal.Validators.NotNullValidator]
        public HospitalIdentifier Facility { get; set; }

        /// <summary>
        /// Gets or sets the HPI-I demographic query.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        [EntLibVal.Validators.ObjectValidator]
        [EntLibVal.Validators.NotNullValidator]
        public DemographicQuery Query { get; set; }
    }
}