﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel;
using System.Text;
using System.Threading.Tasks;

using HIPS.ServiceContracts.Common.DTO.PatientIdentifier;
using HIPS.ServiceContracts.Common.Message;

using EntLibVal = Microsoft.Practices.EnterpriseLibrary.Validation;

namespace HIPS.ServiceContracts.Patient.Message
{
    /// <summary>
    /// Web service request message for the Register Patient operation.
    /// </summary>
    [ServiceKnownType(typeof(RequestBase))]
    [MessageContract(WrapperNamespace = HIPS.ServiceContracts.Common.Constants.ServiceNamespace.PATIENT_V2)]
    public class RegisterPatientRequest : RequestBase
    {
        /// <summary>
        /// The local Medical Record Number of the patient and the facility that is registering the patient.
        /// </summary>
        [MessageBodyMember(Order = 2)]
        [EntLibVal.Validators.NotNullValidator]
        [EntLibVal.Validators.ObjectValidator(ValidateActualType = true)]
        public Mrn Mrn { get; set; }
        
        /// <summary>
        /// Contains Demographics information of the current patient.
        /// </summary>
        [MessageBodyMember(Order = 3)]
        [EntLibVal.Validators.NotNullValidator]
        public Demographic Demographics { get; set; }

        /// <summary>
        /// Contains the validated IHI information of the current patient.
        /// </summary>
        [MessageBodyMember(Order = 4)]        
        public ValidatedIhi IHI { get; set; }
    }
}
