﻿#region Using Directives

using System;
using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.IhiSchemas.Schemas;
using HIPS.ServiceContracts.Common.DTO.ParticipatingIndividual;

#endregion Using Directives

namespace HIPS.ServiceContracts.ServiceInterfaces
{
    /// <summary>
    /// Web service interface for the IHI service.
    /// </summary>
    [WCFExtras.Wsdl.Documentation.XmlComments]
    [ServiceContract(Namespace = "http://schemas.HIPS/Services/2012/01", Name = "IHIService")]
    public interface IIHIService
    {
        /// <summary>
        /// Retrieves a valid IHI and registered demographics for use in a clinical document.
        /// </summary>
        /// <param name="patientIdentifier">Patient identifier (Hospital-level MRN, State Patient ID, Validated IHI or PCEHR Data Store PatientMasterId)</param>
        /// <param name="dateOfBirth">Patient's date of birth (for identity verification)</param>
        /// <param name="user">The user responsible for this action</param>
        /// <returns>Validated IHI information</returns>
        [OperationContract]
        ValidatedIhiResponse GetValidatedIhi(PatientIdentifierBase patientIdentifier, DateTime dateOfBirth, UserDetails user);

        /// <summary>
        /// Obtains validated IHI information for use when sending an e-health message.
        /// </summary>
        /// <param name="patientIdentifier">Hospital-level (MRN) patient identifier.</param>
        /// <param name="dateOfBirth">Patient's date of birth (for identity verification)</param>
        /// <param name="user">The user responsible for this action</param>
        /// <returns>Validated IHI information</returns>
        [OperationContract]
        ValidatedIhiResponse ValidateSendingPatient(Mrn patientIdentifier, DateTime dateOfBirth, UserDetails user);

        /// <summary>
        /// Obtains validated IHI information for use when receiving an e-health message.
        /// </summary>
        /// <param name="consumer">Participation consumer that represents the patient to validate</param>
        /// <param name="hpio">The HPIO of the organisation making the request</param>
        /// <param name="user">The user responsible for this action</param>
        /// <returns>Validated IHI information</returns>
        [OperationContract]
        ValidatedIhiResponse ValidateReceivingPatient(ParticipatingConsumer consumer, string hpio, UserDetails user);
    }
}