﻿using System.IO;

namespace HIPS.DemoHarness
{
    public class Attachment
    {
        private string filePath;
        private byte[] contents;

        public string FilePath
        {
            get
            {
                return filePath;
            }
            set
            {
                filePath = value;
                contents = File.ReadAllBytes(filePath);
            }
        }

        public string FileName
        {
            get
            {
                return Path.GetFileName(FilePath);
            }
        }

        public long FileSize
        {
            get
            {
                return Contents.LongLength;
            }
        }

        public byte[] Contents
        {
            get
            {
                return contents;
            }
        }
    }
}