﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data.SqlClient;
using System.Data.SqlServerCe;
using System.DirectoryServices.AccountManagement;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Security.Principal;
using System.ServiceModel;
using System.ServiceModel.Configuration;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using System.Xml;
using HIPS.Client.Proxy;
using HIPS.CommonSchemas;
using HIPS.DemoHarness.Helpers;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using hipstest.WebServices;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm : Form
    {
        #region Private Members
        HL7DatabaseDataSet hl7DataSet = new HL7DatabaseDataSet();
        List<PatientMaster> patients = null;
        List<Hospital> hospitals = null;
        List<HospitalCode> hospitalCodes = null;
        List<CodeSystem> codeSystems = null;
        List<Episode> episodes = null;
        List<ClinicalDocument> documents = null;

        bool GainAccessTabLoaded = false;
        bool DocListTabLoaded = false;
        bool DownloadDocTabLoaded = false;
        bool ChangeHistoryTabLoaded = false;
        bool PcehrViewTabLoaded = false;
        bool CreateDocTabLoaded = false;

        #endregion
        #region Properties
        /// <summary>
        /// Gets the patients.
        /// </summary>
        private List<PatientMaster> Patients
        {
            get
            {
                if (this.patients == null)
                {
                    this.patients = GetPatients();
                    this.patients = this.patients.OrderBy(result => result.CurrentName.FamilyName).ToList();
                }
                return this.patients;
            }
        }

        /// <summary>
        /// Gets the episodes.
        /// </summary>
        private List<Episode> Episodes
        {
            get
            {
                if (this.episodes == null)
                {
                    this.episodes = GetEpisodes();
                    this.episodes = this.episodes.OrderBy(result => result.AdmissionDate).ToList();
                }
                return this.episodes;
            }
        }

        /// <summary>
        /// Gets the documents for the selected episode.
        /// </summary>
        private List<ClinicalDocument> Documents
        {
            get
            {
                if (this.documents == null)
                {
                    this.documents = GetDocuments();
                    this.documents = this.documents.OrderBy(result => result.SourceSystemSetId).ToList();
                }
                return this.documents;
            }
        }

        /// <summary>
        /// Gets the hospitals.
        /// </summary>
        private List<Hospital> Hospitals
        {
            get
            {
                if (this.hospitals == null)
                {
                    HospitalDl dataAccess = new HospitalDl();
                    this.hospitals = dataAccess.GetAll();
                }
                return this.hospitals;
            }
        }
        private List<HospitalCode> HospitalCodes
        {
            get
            {
                if (this.hospitalCodes == null)
                {
                    HospitalCodeDl dataAccess = new HospitalCodeDl();
                    this.hospitalCodes = dataAccess.GetAll(null);
                }
                return this.hospitalCodes;
            }
        }
        /// <summary>
        /// Gets the code systems.
        /// </summary>
        private List<CodeSystem> CodeSystems
        {
            get
            {
                if (this.codeSystems == null)
                {
                    CodeSystemDl dataAccess = new CodeSystemDl();
                    this.codeSystems = dataAccess.GetAll();
                }
                return this.codeSystems;
            }
        }

        private PatientMaster SelectedPatient
        {
            get
            {
                if (HipsTestHarnessTabControl.SelectedTab == CheckPcehrPage)
                {
                    return tab3PatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == UploadSupersedePage)
                {
                    return UploadPatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == RecordConsentPage)
                {
                    return ConsentPatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == RemoveDocumentPage)
                {
                    return RemovePatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == GainAccessPage)
                {
                    return GainAccessPatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == DocListPage)
                {
                    return DocListPatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == ChangeHistoryPage)
                {
                    return ChangeHistoryPatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == DownloadDocumentPage)
                {
                    return DownloadDocPatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == PcehrViewPage)
                {
                    return PcehrViewPatientComboBox.SelectedItem as PatientMaster;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == CreateDocPage)
                {
                    return CreateDocPatientComboBox.SelectedItem as PatientMaster;
                }
                return null;
            }
        }

        private Episode SelectedEpisode
        {
            get
            {
                if (HipsTestHarnessTabControl.SelectedTab == UploadSupersedePage)
                {
                    return UploadEpisodeComboBox.SelectedItem as Episode;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == RecordConsentPage)
                {
                    return ConsentEpisodeComboBox.SelectedItem as Episode;
                }
                else if (HipsTestHarnessTabControl.SelectedTab == RemoveDocumentPage)
                {
                    return RemoveEpisodeComboBox.SelectedItem as Episode;
                }
                return null;
            }
        }
        #endregion
        public DemoHarnessForm()
        {
            InitializeComponent();
            
            ClientSection clientSection = ConfigurationManager.GetSection("system.serviceModel/client") as ClientSection;
            ChannelEndpointElementCollection endpointCollection =
                clientSection.ElementInformation.Properties[string.Empty].Value as ChannelEndpointElementCollection;
            foreach (ChannelEndpointElement endpointElement in endpointCollection)
            {
                string env = endpointElement.Name.Split(new char[] { '_' })[0];
                if (!environmentComboBox.Items.Contains(env))
                {
                    environmentComboBox.Items.Add(env);
                }
            }
            environmentComboBox.SelectedIndex = 0;
            InteractiveUserButton.Checked = true;
            HL7DatabaseDataSetTableAdapters.HL7TestMessagesTableAdapter hl7Adapters = new HL7DatabaseDataSetTableAdapters.HL7TestMessagesTableAdapter();
            try
            {
                hl7Adapters.Fill(hl7DataSet.HL7TestMessages);
                hl7ComboBox.DataSource = hl7DataSet.HL7TestMessages;
                hl7ComboBox.DisplayMember = "Description";
                hl7ComboBox.ValueMember = "HL7Message";
                hl7ComboBox.SelectedIndexChanged += new EventHandler(hl7ComboBox_SelectedIndexChanged);

            }
            catch (SqlCeException sqlException)
            {
                MessageBox.Show(sqlException.Message + sqlException.StackTrace + System.Environment.CurrentDirectory, "sqlException");

            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message + e.StackTrace, "Exception");
            }
            
            CreateDocModeOfSeparationComboBox.DataSource = new List<SelectListItem<HIPS.ServiceContracts.Common.ModeOfSeparation>>
            {
                new SelectListItem<HIPS.ServiceContracts.Common.ModeOfSeparation>
                {
                    Caption = "",
                    EnumValue = HIPS.ServiceContracts.Common.ModeOfSeparation.None
                },
                new SelectListItem<HIPS.ServiceContracts.Common.ModeOfSeparation>
                {
                    Caption = "Home",
                    EnumValue = HIPS.ServiceContracts.Common.ModeOfSeparation.Home,
                },
                new SelectListItem<HIPS.ServiceContracts.Common.ModeOfSeparation>
                {
                    Caption = "Acute Hospital",
                    EnumValue = HIPS.ServiceContracts.Common.ModeOfSeparation.AcuteHospital,
                },
                new SelectListItem<HIPS.ServiceContracts.Common.ModeOfSeparation>
                {
                    Caption = "Administrative Discharge",
                    EnumValue = HIPS.ServiceContracts.Common.ModeOfSeparation.AdministrativeDischarge,
                },
                new SelectListItem<HIPS.ServiceContracts.Common.ModeOfSeparation>
                {
                    Caption = "Administrative From Leave",
                    EnumValue = HIPS.ServiceContracts.Common.ModeOfSeparation.AdministrativeFromLeave,
                },
                new SelectListItem<HIPS.ServiceContracts.Common.ModeOfSeparation>
                {
                    Caption = "Aged Care Service",
                    EnumValue = HIPS.ServiceContracts.Common.ModeOfSeparation.AgedCareService,
                },
                new SelectListItem<HIPS.ServiceContracts.Common.ModeOfSeparation>
                {
                    Caption = "Deceased",
                    EnumValue = HIPS.ServiceContracts.Common.ModeOfSeparation.Deceased,
                },
                new SelectListItem<HIPS.ServiceContracts.Common.ModeOfSeparation>
                {
                    Caption = "Other Health Service",
                    EnumValue = HIPS.ServiceContracts.Common.ModeOfSeparation.OtherHealthService,
                },
                new SelectListItem<HIPS.ServiceContracts.Common.ModeOfSeparation>
                {
                    Caption = "Psychiatric Care",
                    EnumValue = HIPS.ServiceContracts.Common.ModeOfSeparation.PsychiatricCare,
                },
                new SelectListItem<HIPS.ServiceContracts.Common.ModeOfSeparation>
                {
                    Caption = "Self Discharge",
                    EnumValue = HIPS.ServiceContracts.Common.ModeOfSeparation.SelfDischarge,
                },
            };

            CreateDocDocumentStatusComboBox.DataSource = new List<SelectListItem<HIPS.ServiceContracts.Common.SourceDocumentStatus>>()
            {
                new SelectListItem<HIPS.ServiceContracts.Common.SourceDocumentStatus>
                {
                    Caption="",
                    EnumValue=HIPS.ServiceContracts.Common.SourceDocumentStatus.None
                },

                new SelectListItem<HIPS.ServiceContracts.Common.SourceDocumentStatus>
                {
                    Caption="Interim",
                    EnumValue=HIPS.ServiceContracts.Common.SourceDocumentStatus.Interim
                },

                new SelectListItem<HIPS.ServiceContracts.Common.SourceDocumentStatus>
                {
                    Caption="Final",
                    EnumValue=HIPS.ServiceContracts.Common.SourceDocumentStatus.Final
                },

                new SelectListItem<HIPS.ServiceContracts.Common.SourceDocumentStatus>
                {
                    Caption="Withdrawn",
                    EnumValue=HIPS.ServiceContracts.Common.SourceDocumentStatus.Withdrawn
                },
            };

            SetAuthenticationDetails();
        }

        /// <summary>
        /// Obtains the user's full name, login and domain details and populates them in the text boxes.
        /// </summary>
        private void SetAuthenticationDetails()
        {
            NameTextBox.Text = Environment.UserName;
            LoginTextBox.Text = WindowsIdentity.GetCurrent().Name.Split('\\')[1];
            DomainTextBox.Text = Environment.UserDomainName;
            Thread.GetDomain().SetPrincipalPolicy(PrincipalPolicy.WindowsPrincipal);
            WindowsPrincipal principal = (WindowsPrincipal)Thread.CurrentPrincipal;
            try
            {
                using (PrincipalContext pc = new PrincipalContext(ContextType.Domain))
                {
                    UserPrincipal up = UserPrincipal.FindByIdentity(pc, principal.Identity.Name);
                    NameTextBox.Text = up.DisplayName;
                }
            }
            catch (Exception)
            {
                // Ignore if the domain is not available
            }
        }

        private UserDetails GetUser()
        {
            UserDetails user = new UserDetails();

            if (AuthorisedEmployeeButton.Checked)
            {
                user.Role = UserRole.AuthorisedEmployee;
            }
            else if (InteractiveUserButton.Checked)
            {
                user.Role = UserRole.InteractiveUser;
                user.Login = LoginTextBox.Text;
                user.Domain = DomainTextBox.Text;
                user.Name = NameTextBox.Text;
            }
            else if (HealthProviderIndividualButton.Checked)
            {
                user.Role = UserRole.ProviderIndividual;
                user.HpiI = HpiITextBox.Text;
                user.Name = NameTextBox.Text;
            }
            return user;
        }

        DatabaseLoaderProxy GetDatabaseLoaderServiceClient()
        {
            string endpointConfigurationName = environmentComboBox.Text + "_DatabaseLoaderService";
            DatabaseLoaderProxy client = new DatabaseLoaderProxy(endpointConfigurationName);
            return client;
        }

        IHIProxy GetHIServiceClient()
        {
            string endpointConfigurationName = environmentComboBox.Text + "_IHIService";
            IHIProxy client = new IHIProxy(endpointConfigurationName);
            return client;
        }

        PCEHRProxy GetPcehrServiceClient()
        {
            string endpointConfigurationName = environmentComboBox.Text + "_PCEHRService";
            PCEHRProxy client = new PCEHRProxy(endpointConfigurationName);
            return client;
        }


        class MyFormat : IFormatProvider, ICustomFormatter
        {
            public object GetFormat(Type formatType)
            {
                if (formatType == typeof(ICustomFormatter))
                    return this;
                else
                    return null;
            }

            public string Format(string fmt, object arg, IFormatProvider formatProvider)
            {
                string value = arg as string;
                if (value != null)
                {
                    return "Click to Display";
                }
                return string.Empty;
            }
        }

        private void SetAuditResults(DateTime submittedTime)
        {
            this.ihiLookupAuditTableAdapter.ClearBeforeFill = true;
            this.ihiLookupAuditTableAdapter.Fill(this.pcehrDataStoreDataSet.IhiLookupAudit, submittedTime);
            tab2AuditDataGridView.DataSource = this.pcehrDataStoreDataSet.IhiLookupAudit;
            tab2AuditDataGridView.AutoGenerateColumns = true;


            foreach (DataGridViewColumn col in RemovePcehrAuditGridView.Columns)
            {
                DataGridViewTextBoxColumn textCol = col as DataGridViewTextBoxColumn;
                if (textCol != null)
                {
                    if (textCol.HeaderText == "Request" || textCol.HeaderText == "Response")
                    {
                        //                        textCol.CellTemplate.Style.FormatProvider = new MyFormat();
                        textCol.DefaultCellStyle.Format = "Click";
                        textCol.MaxInputLength = 1048576;
                    }
                    else if (textCol.HeaderText == "Ihi" || textCol.HeaderText == "HpiO")
                    {
                        textCol.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
                    }
                }
            }

            try
            {
                this.pcehrAuditTableAdapter.ClearBeforeFill = true;
                this.pcehrAuditTableAdapter.Fill(this.pcehrDataStoreDataSet.PcehrAudit, submittedTime);

                this.pcehrMessageQueueTableAdapter.ClearBeforeFill = true;
                this.pcehrMessageQueueTableAdapter.Fill(this.pcehrDataStoreDataSet.PcehrMessageQueue, submittedTime);
            }
            catch (Exception ex)
            {
                string a = ex.Message;

                // When running against HIPS R1 we get a spurious error here
                if (a != "Invalid object name 'hips.PcehrAudit'.")
                {
                    throw ex;
                }
            }

            UploadPcehrAuditGridView.Refresh();
            RemovePcehrAuditGridView.Refresh();
            UploadQueueGridView.Refresh();

            //UploadPcehrAuditGridView.DataSource = this.pcehrDataStoreDataSet.PcehrAudit;
            //UploadPcehrAuditGridView.AutoGenerateColumns = true;
            //RemovePcehrAuditGridView.DataSource = this.pcehrDataStoreDataSet.PcehrAudit;
            //RemovePcehrAuditGridView.AutoGenerateColumns = true;
        }

        private void notifyPathButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            outputBox.Text = "Processing the Message";
            outputBox.Refresh();
            var client = GetDatabaseLoaderServiceClient();

            try
            {
                outputBox.Text = client.NotifyPathEvent(inputBox.Text.Replace("\r\n", "\r"), GetUser()).Replace("\r", "\r\n");
                inputBox.Text = string.Empty;
            }
            catch (FaultException<ExceptionDetail> ex)
            {
                outputBox.Text = ex.Message + "\r\n\r\n" + ex.Detail.StackTrace;
            }
            catch (Exception ex)
            {
                outputBox.Text = ex.Message;
            }

            // Always close the client.
            try
            {
                client.Close();
            }
            catch (CommunicationObjectFaultedException)
            {
                // Ignore
            }
            this.Cursor = Cursors.IBeam;
        }

        private void FormatDate_Click(object sender, EventArgs e)
        {
            try
            {
                outputBox.Text = string.Format(inputBox.Text, DateTime.Now);
            }
            catch (FormatException ex)
            {
                outputBox.Text = ex.Message;
            }
        }

        private void SelectAll(object sender, KeyPressEventArgs e)
        {
            //if ((System.Windows.Forms.Control.ModifierKeys == Keys.Control) && (e.KeyChar == (char)Keys.Select))
            //{
            //    ((TextBox)sender).SelectAll();
            //    e.Handled = true;
            //}
            //else
            //{
            //    outputBox.Text = e.KeyChar.ToString();
            //}
        }

        private void SetVisible(bool value, params Control[] controls)
        {
            foreach (Control c in controls)
            {
                c.Visible = value;
            }
        }

        private void SetAuthorisationParameterVisibility()
        {
            SetVisible(InteractiveUserButton.Checked || HealthProviderIndividualButton.Checked, NameLabel, NameTextBox);
            SetVisible(InteractiveUserButton.Checked, LoginLabel, LoginTextBox, DomainLabel, DomainTextBox);
            SetVisible(HealthProviderIndividualButton.Checked, HpiILabel, HpiITextBox);
        }

        private void InteractiveUserButton_CheckedChanged(object sender, EventArgs e)
        {
            SetAuthorisationParameterVisibility();
        }

        private void HealthProviderIndividualButton_CheckedChanged(object sender, EventArgs e)
        {
            SetAuthorisationParameterVisibility();
        }

        private void AuthorisedEmployeeButton_CheckedChanged(object sender, EventArgs e)
        {
            SetAuthorisationParameterVisibility();
        }

        private void TestHarnessForm_Load(object sender, EventArgs e)
        {
            try
            {

                // TODO: This line of code loads data into the 'pcehrDataStoreDataSet.PcehrAudit' table. You can move, or remove it, as needed.
                //this.pcehrAuditTableAdapter.Fill(this.pcehrDataStoreDataSet.PcehrAudit);
                //// TODO: This line of code loads data into the 'pcehrDataStoreDataSet.PatientMaster' table. You can move, or remove it, as needed.
                this.patientMasterTableAdapter.Fill(this.pcehrDataStoreDataSet.PatientMaster);
                //// TODO: This line of code loads data into the 'pcehrDataStoreDataSet.Patient' table. You can move, or remove it, as needed.
                //this.patientTableAdapter.Fill(this.pcehrDataStoreDataSet.Patient);
                //// TODO: This line of code loads data into the 'pcehrDataStoreDataSet.HospitalCode' table. You can move, or remove it, as needed.
                //this.hospitalCodeTableAdapter.Fill(this.pcehrDataStoreDataSet.HospitalCode);
                //// TODO: This line of code loads data into the 'pcehrDataStoreDataSet.CodeSystem' table. You can move, or remove it, as needed.
                //this.codeSystemTableAdapter.Fill(this.pcehrDataStoreDataSet.CodeSystem);

            }
            catch (Exception ex)
            {
                string msg = string.Format(
                    @"Please review the following settings in HIPS.DemoHarness.exe.config and launch the application again.

Database: {0}
Server: {1}

Message: {2}",
                    this.patientMasterTableAdapter.Connection.Database,
                    this.patientMasterTableAdapter.Connection.DataSource,
                    ex.Message);
                MessageBox.Show(msg, "Unable to access HIPS database");
                Application.Exit();
            }

            DocListStatus.SelectedIndex = 0;
        }

        TextBox[] ResultsTextBoxes
        {
            get
            {
                return new TextBox[]
                {
                    IhiLookupReturnStatusTextBox,
                    IhiTextBox,
                    IhiRecordStatusTextBox,
                    IhiStatusTextBox,
                    LastValidatedDateTimeTextBox,
                    SexTextBox,
                    GivenNamesTextBox,
                    FamilyNameTextBox,
                    AdvertisedStatusTextBox,
                    AccessStatusTextBox,
                    PcehrExistsReturnStatusTextBox,
                    ConsentErrorIndicatorTextBox,
                    RecentParticipationErrorIndicatorTextBox,
                    SinglePatientParticipationErrorIndicatorTextBox
                };
            }
        }

        private void ClearResults()
        {
            foreach (TextBox box in ResultsTextBoxes)
            {
                box.Text = "";
            }
            tab2AuditDataGridView.DataSource = null;
            PatientParticipationGridView.DataSource = null;
            //            UploadPcehrAuditGridView.DataSource = null;
        }

        //private void CodeSystemComboBox_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    //            HospitalCodeComboBox.Text = CodeSystemComboBox.SelectedItem.GetType().ToString();
        //    DataRowView row = (DataRowView)CodeSystemComboBox.SelectedItem;
        //    if (row != null)
        //    {
        //        hospitalCodeBindingSource.Filter = string.Format("CodeSystemId=2");
        //        hospitalCodeBindingSource.Filter = "CodeSystemId=" + row.Row["CodeSystemId"];
        //    }
        //    else
        //    {
        //        hospitalCodeBindingSource.Filter = string.Format("CodeSystemId=2");
        //    }
        //    HospitalCodeComboBox_SelectedIndexChanged(sender, e);
        //}

        //private void HospitalCodeComboBox_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    DataRowView row = (DataRowView)HospitalCodeComboBox.SelectedItem;
        //    if (row != null)
        //    {
        //        patientBindingSource.Filter = "HospitalId=" + row.Row["HospitalId"];
        //    }
        //    else
        //    {
        //        patientBindingSource.Filter = "1=0";
        //    }
        //    MrnComboBox_SelectedIndexChanged(sender, e);
        //}

        //private void MrnComboBox_SelectedIndexChanged(object sender, EventArgs e)
        //{
        //    DataRowView row = (DataRowView)MrnComboBox.SelectedItem;
        //    if (row != null)
        //    {
        //        patientMasterBindingSource.Filter = "PatientMasterId=" + row.Row["PatientMasterId"];
        //    }
        //    else
        //    {
        //        patientMasterBindingSource.Filter = "1=0";
        //    }
        //    row = (DataRowView)DateOfBirthComboBox.SelectedItem;
        //    if (row != null)
        //    {
        //        DateTime? dateOfBirth = row.Row["DateOfBirth"] as DateTime?;
        //        DateOfBirthPicker.Value = dateOfBirth.Value;
        //    }
        //    else
        //    {
        //        DateOfBirthPicker.Text = "";
        //    }
        //    ClearResults();
        //}

        private void ShowException(Exception ex, TextBox textBox)
        {
            StringBuilder message = new StringBuilder();
            while (ex != null)
            {
                message.AppendLine(ex.GetType().ToString());
                message.AppendLine(ex.Message);
                if (ex is FaultException<ExceptionDetail>)
                {
                    message.AppendLine((ex as FaultException<ExceptionDetail>).Detail.StackTrace);
                }
                message.AppendLine();
                ex = ex.InnerException;
            }
            textBox.Text = message.ToString();
            textBox.Visible = true;
            textBox.BringToFront();
        }

        private string GetSelectedPatientHospitalCode()
        {
            HospitalPatientDl dataAccess = new HospitalPatientDl(GetUser());
            HospitalPatient patient = null;
            if (SelectedEpisode != null)
            {
                dataAccess.Get(SelectedEpisode.PatientId, out patient);
            }
            else if (SelectedPatient != null)
            {
                // Don't need to match to an episode, doesn't matter which hospital we select.
                patient = dataAccess.GetAll(null, SelectedPatient.PatientMasterId.Value).FirstOrDefault();
            }

            if (patient == null || !patient.PatientId.HasValue)
            {
                return null;
            }
            int? codeSystemId = (from result in CodeSystems where result.Code == GetHospitalCodeSystem() select (result.CodeSystemId)).First();
            string code = (from result in HospitalCodes where result.CodeSystemId == codeSystemId && result.HospitalId == patient.HospitalId select result.Code).First();
            return code;
        }

        /// <summary>
        /// Gets the selected patient MRN.
        /// </summary>
        /// <returns></returns>
        private string GetSelectedPatientMrn()
        {
            HospitalPatientDl dataAccess = new HospitalPatientDl(GetUser());
            HospitalPatient patient = null;
            if (SelectedEpisode != null)
            {
                dataAccess.Get(SelectedEpisode.PatientId, out patient);
            }
            else if (SelectedPatient != null)
            {
                // Don't need to match to an episode, doesn't matter which hospital we select.
                patient = dataAccess.GetAll(null, SelectedPatient.PatientMasterId.Value).FirstOrDefault();
            }

            if (patient == null || !patient.PatientId.HasValue)
            {
                return null;
            }
            return patient.Mrn;
        }
        /// <summary>
        /// Gets the selected patient date of birth.
        /// </summary>
        /// <returns></returns>
        private DateTime GetSelectedPatientDateOfBirth()
        {
            return SelectedPatient.DateOfBirth;
        }

        private string GetHospitalCodeSystem()
        {
            return "pasFacCd";
        }

        /// <summary>
        /// Shows a HIPS response in a text box.
        /// </summary>
        /// <param name="textBox"></param>
        /// <param name="response"></param>
        private void ShowResponse(TextBox textBox, HipsResponse response)
        {
            StringBuilder sb = new StringBuilder();
            sb.AppendFormat("Status: {0}\r\n", response.Status);
            if (!string.IsNullOrEmpty(response.HipsErrorMessage))
            {
                sb.AppendFormat("Message: {0}\r\n", response.HipsErrorMessage);
            }
            if (!string.IsNullOrEmpty(response.ResponseCode))
            {
                sb.AppendFormat("Code: {0}\r\n", response.ResponseCode);
            }
            if (!string.IsNullOrEmpty(response.ResponseCodeDescription))
            {
                sb.AppendFormat("Description: {0}\r\n", response.ResponseCodeDescription);
            }
            if (!string.IsNullOrEmpty(response.ResponseCodeDetails))
            {
                sb.AppendFormat("nDetails: {0}\r\n", response.ResponseCodeDetails);
            }
            textBox.Text = sb.ToString();
            textBox.Visible = true;
        }

        /// <summary>
        /// Clears the datastore results.
        /// </summary>
        private void ClearDatastoreResults()
        {
            tab2DateOfBirthTextBox.Text = string.Empty;
            tab2DvaTextBox.Text = string.Empty;
            tab2FirstNameTextBox.Text = string.Empty;
            tab2IhiRecordStatusTextBox.Text = string.Empty;
            tab2IhiStatusTextBox.Text = string.Empty;
            tab2IhiTextBox.Text = string.Empty;
            tab2IrnTextBox.Text = string.Empty;
            tab2MedicareTextBox.Text = string.Empty;
            tab2SexTextbox.Text = string.Empty;
            tab2DateLastValidatedTextBox.Text = string.Empty;
            tab2PcehrAdvertisedLabel.Text = "PCEHR Advertised - Not Known";
        }

        /// <summary>
        /// Sets the panel.
        /// </summary>
        /// <param name="panelType">Type of the panel.</param>
        /// <param name="message">The message.</param>
        private void SetPanel(StatusPanelType panelType, string message = "")
        {
            switch (panelType)
            {
                case StatusPanelType.Results:
                    tab2StatusPanel.Visible = false;
                    tab2ValidResultsPanel.Visible = true;
                    break;
                default:
                    tab2StatusLabel.Text = message;
                    tab2StatusPanel.Visible = true;
                    tab2ValidResultsPanel.Visible = false;
                    break;
            }
        }

        /// <summary>
        /// Displays the results.
        /// </summary>
        /// <param name="patientMaster">The patient master.</param>
        private void DisplayResults(PatientMaster patientMaster, HealthProviderOrganisationPatient hpop)
        {
            tab2DateOfBirthTextBox.Text = string.Format("{0:dd/MM/yyyy}", patientMaster.DateOfBirth);
            tab2DvaTextBox.Text = patientMaster.DvaNumber;
            tab2FirstNameTextBox.Text = string.Format("{0} {1}", patientMaster.CurrentName.GivenNames, patientMaster.CurrentName.FamilyName);
            tab2IhiRecordStatusTextBox.Text = patientMaster.IhiRecordStatus;
            tab2IhiStatusTextBox.Text = patientMaster.IhiStatus;
            tab2IhiTextBox.Text = patientMaster.Ihi;
            tab2IrnTextBox.Text = patientMaster.MedicareIrn;
            tab2MedicareTextBox.Text = patientMaster.MedicareNumber;
            if (patientMaster.IhiLastValidated != DateTime.MinValue)
            {
                tab2DateLastValidatedTextBox.Text = string.Format("{0:dd/MM/yyyy HH:mm}", patientMaster.IhiLastValidated);
                if (hpop.PcehrAdvertised.HasValue)
                {
                    if (hpop.PcehrAdvertised.Value)
                    {
                        tab2PcehrAdvertisedLabel.Text = "PCEHR is Advertised";
                    }
                    else
                    {
                        tab2PcehrAdvertisedLabel.Text = "PCEHR is not Advertised";
                    }

                }
                else
                {
                    tab2PcehrAdvertisedLabel.Text = "PCEHR Advertised - Not Known";
                }
            }
            else
            {
                tab2PcehrAdvertisedLabel.Text = "IHI Does not exist or cannot be found";
            }

            switch (patientMaster.CurrentSexId)
            {
                case 1:
                    tab2SexTextbox.Text = "Male";
                    break;
                case 2:
                    tab2SexTextbox.Text = "Female";
                    break;
                case 3:
                    tab2SexTextbox.Text = "Intersex/Indeterminate";
                    break;
                case 4:
                    tab2SexTextbox.Text = "Not Specified";
                    break;
            }

        }

        private void GetPatientByHospitalMrn(string mrn, string hospitalCode)
        {
            PatientMaster patientMaster = new PatientMaster();
            PatientMasterDl dataAccess = new PatientMasterDl(GetUser());
            HospitalDl hospitalDataAccess = new HospitalDl();
            Hospital hospital = hospitalDataAccess.Get(2, hospitalCode);
            bool result = dataAccess.GetByHospitalCodeMrn(mrn, hospitalCode, 2, hospital.HealthProviderOrganisationNetworkId, out patientMaster);
            if (result)
            {
                HealthProviderOrganisationPatientDl hpopDataAccess = new HealthProviderOrganisationPatientDl(GetUser());
                HealthProviderOrganisationPatient hpop;
                hpopDataAccess.Get(hospital.HpiO, patientMaster.PatientMasterId.Value, out hpop);
                DisplayResults(patientMaster, hpop);
                SetPanel(StatusPanelType.Results);

            }
            else
            {
                ClearDatastoreResults();
                SetPanel(StatusPanelType.Status, "Could not find the patient in the PCEHR Data Store");
            }
            //string connection = ConfigurationManager.ConnectionStrings["hipstest.Properties.Settings.PcehrDataStoreConnectionString"].ToString();
            //using (SqlCommand command = new SqlCommand())
            //{
            //    command.Connection = new SqlConnection(connection);
            //    command.CommandType = CommandType.Text;
            //    command.Connection.Open();
            //    //int hospitalId = GetHospitalId(hospitalCode, command);
            //    //int patientMasterId = GetPatientMasterId(mrn, hospitalId, command);
            //    PatientMasterDl da = new PatientMasterDl();
            //    da.Get(
            //}
        }

        /// <summary>
        /// Gets the patient id.
        /// </summary>
        /// <param name="hospitalCode">The hospital code.</param>
        /// <param name="command">The command.</param>
        /// <returns></returns>
        private int GetHospitalId(string hospitalCode, SqlCommand command)
        {
            int result = -1;
            command.CommandText = string.Format("SELECT hc.HospitalId FROM [hips].[HospitalCode] hc WHERE hc.CodeSystemId = 2 AND hc.Code = '{0}'", hospitalCode);
            result = System.Convert.ToInt32(command.ExecuteScalar());
            return result;
        }
        /// <summary>
        /// Gets the patient master id.
        /// </summary>
        /// <param name="mrn">The MRN.</param>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="command">The command.</param>
        /// <returns></returns>
        private int GetPatientMasterId(string mrn, int hospitalId, SqlCommand command)
        {
            int result = -1;
            command.CommandText = string.Format("SELECT p.PatientMasterId FROM [hips].[patient] p  WHERE p.Mrn = '{0}' AND p.HospitalId = {1}", mrn, hospitalId);
            result = System.Convert.ToInt32(command.ExecuteScalar());
            return result;
        }

        private string GetMrnFromPasMessage(string pasMessage)
        {
            string result = string.Empty;
            string[] segments = pasMessage.Split('\r', '\n');
            string segment = segments.FirstOrDefault(a => a.StartsWith("PID|"));
            if (segment != null)
            {
                string field = segment.Split('|')[3];
                string repeat = field.Split('~')[0];
                string component = repeat.Split('^')[0];
                result = component;
                result = result.PadLeft(9, '0'); // Pad MRN to 9 characters because HIPS will do the same.
            }
            return result;
        }

        /// <summary>
        /// Gets the admission date.
        /// </summary>
        /// <param name="pasMessage">The pas message.</param>
        /// <returns></returns>
        private DateTime GetAdmissionDate(string pasMessage)
        {
            DateTime result = DateTime.Now;
            string[] lines = pasMessage.Split('\n');
            foreach (string line in lines)
            {
                int p = line.IndexOf("PV1|");
                if (p > -1)
                {
                    string[] segments = line.Split('|');
                    string admissionDate = segments[44];
                    CultureInfo provider = CultureInfo.InvariantCulture;
                    DateTime objDate = DateTime.ParseExact(admissionDate, "yyyyMMddhhmmss", provider);
                    return objDate;
                }
            }

            return result;
        }
        private string GetHospitalCode(string pasMessage)
        {
            string result = string.Empty;
            string[] segments = pasMessage.Split('\r', '\n');
            string segment = segments.FirstOrDefault(a => a.StartsWith("PID|"));
            if (segment != null)
            {
                string field = segment.Split('|')[3];
                string repeat = field.Split('~')[0];
                string component = repeat.Split('^')[3];
                result = component;
            }
            return result;
        }


        private void HipsTestHarnessTabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.SuspendLayout();
            TabControl control = sender as TabControl;
            if (control.SelectedTab == CheckPcehrPage)
            {
                this.Cursor = Cursors.WaitCursor;
                this.patients = null;
                tab3PatientComboBox.DataSource = Patients;
                tab3PatientComboBox.DisplayMember = "CurrentName";
                tab3PatientComboBox.ValueMember = "PatientMasterId";
                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == UploadSupersedePage)
            {
                this.Cursor = Cursors.WaitCursor;
                this.patients = null;
                UploadPatientComboBox.DataSource = Patients;
                UploadPatientComboBox.DisplayMember = "CurrentName";
                UploadPatientComboBox.ValueMember = "PatientMasterId";

                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == RecordConsentPage)
            {
                this.Cursor = Cursors.WaitCursor;
                this.patients = null;
                ConsentPatientComboBox.DataSource = Patients;
                ConsentPatientComboBox.DisplayMember = "CurrentName";
                ConsentPatientComboBox.ValueMember = "PatientMasterId";

                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == RemoveDocumentPage)
            {
                this.Cursor = Cursors.WaitCursor;
                this.patients = null;
                RemovePatientComboBox.DataSource = Patients;
                RemovePatientComboBox.DisplayMember = "CurrentName";
                RemovePatientComboBox.ValueMember = "PatientMasterId";
                RemoveReasonComboBox.DataSource = typeof(RemovalReason).GetEnumValues();
                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == GainAccessPage)
            {
                this.Cursor = Cursors.WaitCursor;
                if (!GainAccessTabLoaded)
                {
                    this.patients = null;
                    GainAccessPatientComboBox.DataSource = Patients;
                    GainAccessPatientComboBox.DisplayMember = "CurrentName";
                    GainAccessPatientComboBox.ValueMember = "PatientMasterId";
                    GainAccessTabLoaded = true;
                }
                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == DocListPage)
            {
                this.Cursor = Cursors.WaitCursor;
                if (!DocListTabLoaded)
                {
                    this.patients = null;
                    DocListPatientComboBox.DataSource = Patients;
                    DocListPatientComboBox.DisplayMember = "CurrentName";
                    DocListPatientComboBox.ValueMember = "PatientMasterId";
                    DocListTabLoaded = true;
                }
                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == ChangeHistoryPage)
            {
                this.Cursor = Cursors.WaitCursor;

                if (!ChangeHistoryTabLoaded)
                {
                    this.patients = null;
                    ChangeHistoryPatientComboBox.DataSource = Patients;
                    ChangeHistoryPatientComboBox.DisplayMember = "CurrentName";
                    ChangeHistoryPatientComboBox.ValueMember = "PatientMasterId";
                    ChangeHistoryTabLoaded = true;
                }
                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == DownloadDocumentPage)
            {
                this.Cursor = Cursors.WaitCursor;

                if (!DownloadDocTabLoaded)
                {
                    this.patients = null;
                    DownloadDocPatientComboBox.DataSource = Patients;
                    DownloadDocPatientComboBox.DisplayMember = "CurrentName";
                    DownloadDocPatientComboBox.ValueMember = "PatientMasterId";
                    DownloadDocTabLoaded = true;
                }
                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == PcehrViewPage)
            {
                this.Cursor = Cursors.WaitCursor;

                if (!PcehrViewTabLoaded)
                {
                    this.patients = null;
                    PcehrViewPatientComboBox.DataSource = Patients;
                    PcehrViewPatientComboBox.DisplayMember = "CurrentName";
                    PcehrViewPatientComboBox.ValueMember = "PatientMasterId";
                    PcehrViewPatientComboBox.SelectedIndex = -1;
                    PcehrViewTabLoaded = true;
                }
                this.Cursor = Cursors.Default;
            }
            else if (control.SelectedTab == CreateDocPage)
            {
                this.Cursor = Cursors.WaitCursor;

                if (!CreateDocTabLoaded)
                {
                    this.patients = null;
                    CreateDocPatientComboBox.DataSource = Patients;
                    CreateDocPatientComboBox.DisplayMember = "CurrentName";
                    CreateDocPatientComboBox.ValueMember = "PatientMasterId";
                    CreateDocPatientComboBox.SelectedIndex = -1;
                    CreateDocTabLoaded = true;
                }
                this.Cursor = Cursors.Default;
            }
            this.ResumeLayout();
        }

        /// <summary>
        /// Gets the patients.
        /// </summary>
        /// <returns></returns>
        private List<PatientMaster> GetPatients()
        {
            this.patientMasterTableAdapter.ClearBeforeFill = true;
            this.patientMasterTableAdapter.Fill(this.pcehrDataStoreDataSet.PatientMaster);
            List<PatientMaster> patientMasterList = new List<PatientMaster>();
            List<HIPS.DemoHarness.PcehrDataStoreDataSet.PatientMasterRow> dataList = pcehrDataStoreDataSet.PatientMaster.ToList();
            foreach (HIPS.DemoHarness.PcehrDataStoreDataSet.PatientMasterRow row in dataList)
            {
                PatientMaster pm = new PatientMaster();
                pm.SetNewCurrentName(null, row.GivenNames, row.FamilyName, null);
                pm.CurrentSexId = row.CurrentSexId;
                pm.DateOfDeath = row.IsDateOfDeathNull() ? null : (DateTime?)row.DateOfDeath;
                pm.DateOfBirth = row.DateOfBirth;
                pm.DvaNumber = row.IsDvaNumberNull() ? null : row.DvaNumber; ;
                pm.PatientMasterId = row.PatientMasterId;
                patientMasterList.Add(pm);
            }
            return patientMasterList;
        }

        /// <summary>
        /// Gets the episodes for the selected patient.
        /// </summary>
        /// <returns></returns>
        private List<Episode> GetEpisodes()
        {
            HospitalPatientDl hospitalPatientDataAccess = new HospitalPatientDl(GetUser());
            List<HospitalPatient> patients = hospitalPatientDataAccess.GetAllActive(SelectedPatient.PatientMasterId.Value);
            EpisodeDl dataAccess = new EpisodeDl(GetUser());
            return patients.SelectMany(a => dataAccess.GetAll(a.PatientId, null)).ToList();
        }

        /// <summary>
        /// Gets the documents for the selected episode.
        /// </summary>
        /// <returns></returns>
        private List<ClinicalDocument> GetDocuments()
        {
            if (SelectedEpisode == null)
            {
                return new List<ClinicalDocument>();
            }

            ClinicalDocumentDl documentDataAccess = new ClinicalDocumentDl(GetUser());

            return documentDataAccess.GetAll(SelectedEpisode.EpisodeId.Value, null);
        }

        private void AnyAuditDataGridViewClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.ColumnIndex < 0)
            {
                return;
            }
            DataGridView view = sender as DataGridView;
            string name = view.Columns[e.ColumnIndex].HeaderText;
            if (name == "Request" || name == "Response")
            {
                string title = string.Format("{0} Message", name);
                MessageForm form = new MessageForm(title, PrintXml(view.CurrentCell.Value.ToString()));
                form.ShowDialog();
            }
            else if (name == "ServiceMessage" || name == "Details")
            {
                MessageForm form = new MessageForm(name, view.CurrentCell.Value.ToString());
                form.ShowDialog();
            }
        }

        /// <summary>
        /// Prints the XML.
        /// </summary>
        /// <param name="xml">The XML.</param>
        /// <returns></returns>
        public string PrintXml(string xml)
        {
            if (!tab2FormatXmlcheckBox.Checked)
            {
                return xml;
            }
            String Result = "";

            using (MemoryStream mStream = new MemoryStream())
            {
                using (XmlTextWriter writer = new XmlTextWriter(mStream, Encoding.Unicode))
                {
                    XmlDocument document = new XmlDocument();

                    try
                    {
                        // Load the XmlDocument with the XML.
                        document.LoadXml(xml);

                        writer.Formatting = Formatting.Indented;

                        // Write the XML into a formatting XmlTextWriter
                        document.WriteContentTo(writer);
                        writer.Flush();
                        mStream.Flush();

                        // Have to rewind the MemoryStream in order to read
                        // its contents.
                        mStream.Position = 0;

                        // Read MemoryStream contents into a StreamReader.
                        StreamReader sReader = new StreamReader(mStream);

                        // Extract the text from the StreamReader.
                        String FormattedXML = sReader.ReadToEnd();

                        Result = FormattedXML;
                    }
                    catch (XmlException)
                    {
                    }

                    writer.Close();
                }
                mStream.Close();
            }

            return Result;
        }

        private void environmentComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            var client = GetDatabaseLoaderServiceClient();
            this.Text = "HIPS Demo Harness - " + client.Endpoint.Address.Uri.Host;
        }

    }
}
