﻿using System;
using System.Text;
using System.Windows.Forms;

using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PcehrSchemas;

namespace HIPS.DemoHarness
{
    public partial class DemoHarnessForm
    {
        private void GainAccessPatientComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            //get patient
            GainAccessButton.Enabled = false;
            string hospitalCode = GetSelectedPatientHospitalCode();
            string codingSystem = GetHospitalCodeSystem();
            string mrn = GetSelectedPatientMrn();
            ClearResults();
            GainAccessHospitalCodeReadOnlyTextBox.Text = GetSelectedPatientHospitalCode();
            GainAccessMrnReadOnlyTextBox.Text = GetSelectedPatientMrn();
            GainAccessDateOfBirthReadOnlyTextBox.Text = string.Format("{0:dd/MM/yyyy}", SelectedPatient.DateOfBirth);
            GainAccessHospitalCodeSystemReadOnlyTextBox.Text = GetHospitalCodeSystem();

        }

        private void GainAccessPopulateIHI_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;

            //get PCEHRStatus
            GainAccessMessagesTextBox.Visible = false;
            GainAccessMessagesTextBox.Text = "";
            GainAccessIHITextBox.Text = "";
            GainAccessIHIStatusTextBox.Text = "";
            GainAccessIHIRecordStatusTextBox.Text = "";
            GainAccessPermissionTextBox.Text = "";
            var client = GetPcehrServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();

                DoesPcehrExistResponse response = client.IsPcehrAdvertised(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), dateOfBirth, GetUser());
                GainAccessPcehrReturnStatusTextBox.Text = response.HipsResponse.ToString();

                if (response.PcehrExists.HasValue)
                {
                    GainAccessAdvertisedStatusTextBox.Text = response.PcehrExists.Value ? "Yes, an advertised PCEHR exists." : "No PCEHR exists, or the owner has chosen not to advertise its existence.";
                }
                else
                {
                    GainAccessAdvertisedStatusTextBox.Text = "Unknown";
                }
                switch (response.AccessCodeRequired)
                {
                    case AccessCodeRequired.Unknown:
                        GainAccessPcehrAccessStatusTextBox.Text = "Unknown";
                        break;
                    case AccessCodeRequired.AccessGranted:
                        GainAccessPcehrAccessStatusTextBox.Text = "Your organisation has already gained access to this PCEHR.";
                        break;
                    case AccessCodeRequired.WithCode:
                        GainAccessPcehrAccessStatusTextBox.Text = "Access to this PCEHR is restricted. You can gain access with the code or assert emergency access.";
                        break;
                    case AccessCodeRequired.WithoutCode:
                        GainAccessPcehrAccessStatusTextBox.Text = "Access to this PCEHR is not restricted. You can gain access without a code.";
                        break;
                }
                GainAccessButton.Enabled = true;
            }
            catch (Exception ex)
            {
                ShowException(ex, GainAccessMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }

            this.Cursor = Cursors.Default;


        }

        private void AccessWithCodeRadioButton_CheckedChanged(object sender, EventArgs e)
        {
            if (((RadioButton)sender).Checked)
            {
                AccessCodeTextBox.Enabled = true;
            }
            else
            {
                AccessCodeTextBox.Enabled = false;
            }
        }

        private void GainAccessButton_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            GainAccessMessagesTextBox.Visible = false;
            GainAccessMessagesTextBox.Text = "";
            GainAccessIHITextBox.Text = "";
            GainAccessIHIStatusTextBox.Text = "";
            GainAccessIHIRecordStatusTextBox.Text = "";
            GainAccessPermissionTextBox.Text = "";
            var client = GetPcehrServiceClient();
            try
            {
                string hospitalCode = GetSelectedPatientHospitalCode();
                string codingSystem = GetHospitalCodeSystem();
                string mrn = GetSelectedPatientMrn();
                DateTime dateOfBirth = GetSelectedPatientDateOfBirth();

                GainPcehrAccessResponse gainAccessResponse = new GainPcehrAccessResponse();

                if (AccessWithCodeRadioButton.Checked)
                {
                    gainAccessResponse = client.GainAccessWithCode(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), AccessCodeTextBox.Text, GetUser());
                }
                else if (AccessWithOutCodeRadioButton.Checked)
                {
                    gainAccessResponse = client.GainAccessWithOutCode(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser());
                }
                else if (EmergencyAccessRadioButton.Checked)
                {
                    gainAccessResponse = client.GainAccessEmergency(new Mrn(mrn, hospitalCode, GetHospitalCodeSystem()), GetUser());
                }

                GainAccessIHITextBox.Text = gainAccessResponse.IHINumber;
                GainAccessIHIStatusTextBox.Text = gainAccessResponse.IhiStatus.ToString();
                GainAccessIHIRecordStatusTextBox.Text = gainAccessResponse.IhiRecordStatus.ToString();
                GainAccessPermissionTextBox.Text = gainAccessResponse.AccessPermission.ToString();

                StringBuilder message = new StringBuilder();
                message.AppendLine("Status:" + gainAccessResponse.HipsResponse.Status);

                if (gainAccessResponse.HipsResponse.Status != HipsResponseIndicator.OK)
                {
                    message.AppendLine("ResponseCode:" + gainAccessResponse.HipsResponse.ResponseCode);
                    message.AppendLine("ResponseCodeDescription:" + gainAccessResponse.HipsResponse.ResponseCodeDescription);
                    message.AppendLine("ResponseCodeDetails:" + gainAccessResponse.HipsResponse.ResponseCodeDetails);
                    message.AppendLine("HipsErrorMessage:" + gainAccessResponse.HipsResponse.HipsErrorMessage);
                }
                GainAccessMessagesTextBox.Text = message.ToString();
                GainAccessMessagesTextBox.Visible = true;
            }
            catch (Exception ex)
            {
                ShowException(ex, GainAccessMessagesTextBox);
            }
            finally
            {
                try
                {
                    client.Close();
                }
                catch (Exception)
                {
                    // Ignore exception while closing client
                }
            }
            this.Cursor = Cursors.Default;
        }
    }
}
