using System;

namespace HIPS.Web.BusinessLogic.Identification
{
    public static class DvaValidator
    {
        /// <summary>
        /// </summary>
        /// <returns>
        ///     If valid, an empty List.
        ///     Otherwise, a List containing error(s).
        ///     A DVA File Number is valid if:
        ///     * 8-9 characters long.
        ///     * 1st character is the state code (an alphabetic character).
        ///     - N, V, Q, W, S or T for the appropriate state/territory.
        ///     - ACT is included in NSW (N).
        ///     - NT is included in SA (S).
        ///     * Next 7 characters are the file code (war code +  numeric digits).
        ///     - (blank) + 6 numeric digits (no war code, e.g. WW1).
        ///     - 1 alpha + 6 numeric digits (single character war code).
        ///     - 2 alpha + 5 numeric digits (two character war code).
        ///     - 3 alpha + 4 numeric digits (three character war code).
        ///     * (Optional) 8th character is segment link.
        ///     - 1 alpha if veteran dependent
        ///     - (blank) or not provided if veteran
        /// </returns>
        public static bool IsValidDvaFileNumber(string dvaFileNumber)
        {
            if (String.IsNullOrWhiteSpace(dvaFileNumber) || dvaFileNumber.Length < 8 || dvaFileNumber.Length > 9)
            {
                return false;
            }

            //TODO: Expand?

            return true;
        }
    }
}