﻿using System.Web.Configuration;
using System.Web.Mvc;

namespace HIPS.Web.Components.Cache
{
    /// <summary>
    /// Extends the MVC <see cref="OutputCacheAttribute"/> to support decoration of child actions for use with partial views.
    /// </summary>
    /// <remarks>
    /// Required because the standard MVC OutputCacheAttribute does not support being applied to child actions in controllers (using a cache profile defined in config).
    /// Refer to http://thenullreference.com/blog/fixing-the-asp-net-mvc-3-outputcacheattribute-for-partial-views-to-honor-some-web-config-settings/ (MVC 3, but doesn't appear to be fixed in MVC 4).
    /// </remarks>
    public class PartialOutputCacheAttribute : OutputCacheAttribute
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="PartialOutputCacheAttribute"/> class.
        /// </summary>
        /// <param name="cacheProfileName">Name of the output cache profile defined in the web.config file to be employed by the output cache.</param>
        public PartialOutputCacheAttribute(string cacheProfileName)
        {
            // Retrieve the relevant section from the configuration file.
            var cacheSection = (OutputCacheSettingsSection)WebConfigurationManager.GetSection("system.web/caching/outputCacheSettings");

            if (cacheSection != null)
            {
                // Retrieve the specified output cache profile from configuration.
                var cacheProfile = cacheSection.OutputCacheProfiles[cacheProfileName];

                if (cacheProfile != null)
                {
                    // Set the properties of the attribute based on the output cache profile settings in the configuration file.
                    this.Duration = cacheProfile.Duration;
                    this.VaryByParam = cacheProfile.VaryByParam;
                }
            }
        }

        #endregion Constructors
    }
}