using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;

namespace HIPS.Web.Components.Collections
{
    /// <summary>
    ///     Extensions to the generic IEnumerable interface.
    /// </summary>
    public static class IEnumerableExtensions
    {
        /// <summary>
        ///     Creates an enumeration of SelectListItems from this enumeration
        ///     using the provided Value and Text selectors.
        /// </summary>
        /// <typeparam name="T">Type of elements in this enumerable.</typeparam>
        /// <param name="enumerable">This enumerable.</param>
        /// <param name="valueSelector">Selector for determining the 'Value' of each SelectListItem.</param>
        /// <param name="textSelector">Select for determining the 'Text' of each SelectListItem.</param>
        /// <returns>A collection of SelectListItems</returns>
        public static IEnumerable<SelectListItem> ToSelectListItems<T>(this IEnumerable<T> enumerable, Func<T, string> valueSelector, Func<T, string> textSelector, Func<T, bool> selectedSelector = null)
        {
            if (selectedSelector != null)
            {
                return enumerable.Select(e => new SelectListItem { Value = valueSelector.Invoke(e), Text = textSelector.Invoke(e), Selected = selectedSelector.Invoke(e) }).ToList();
            }

            return enumerable.Select(e => new SelectListItem { Value = valueSelector.Invoke(e), Text = textSelector.Invoke(e) }).ToList();
        }
    }
}