﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Components.Common
{
    /// <summary>
    /// Extensions for strings.
    /// </summary>
    public static class StringExtensions
    {
        /// <summary>
        /// Formats the given string to a valid Hpio format.
        /// </summary>
        /// <param name="value">The string to format.</param>
        /// <returns>String formatted as Hpio</returns>
        public static string ToHpioFormat(this string value)
        {
            /* This method can be replaced by
             * Regex.Replace(1234567890123456, @"^(....)(....)(....)(....)$", "$1-$2-$3-$4")
             * which results to 1234-5678-9012-3456.
             
             * This implementation is much readable compared to Regex.
             */
            
            var builder = new StringBuilder(value);
            int separatorPosition = 4;

            for (int i = separatorPosition; i < value.Length; i += separatorPosition + 1)
            {
                builder.Insert(i, '-');
            }

            return builder.ToString();
        }
        
        /// <summary>
        /// Extracts the number for the given string.
        /// </summary>
        /// <param name="value">The string to extract numbers from.</param>
        /// <returns>String consists of numbers only.</returns>
        public static string ExtractNumbers(this string value)
        {
            return new string(
                value.ToCharArray()
                     .Where(c => char.IsNumber(c))
                     .ToArray());
        }
    }
}
