﻿using System;

namespace HIPS.Web.Components.ServiceModel
{
    public class ServiceResponse<T>
    {
        /// <summary>
        /// The response data (may be null).
        /// </summary>
        public T Data { get; set; }

        /// <summary>
        /// A value indicating whether the response indicates a successful request.
        /// </summary>
        public bool IsSuccessful { get; set; }

        /// <summary>
        /// Messages related to the response (if any).
        /// </summary>
        public ResponseMessageList Messages { get; set; }

        /// <summary>
        /// Gets or sets the date and time the response was received.
        /// </summary>
        public DateTime ReceiptTimestamp { get; set; }

        /// <summary>
        /// Initialises a new instance of the <see cref="ServiceResponse{T}"/> class.
        /// </summary>
        /// <param name="data">The data of the response (may be null).</param>
        /// <param name="isSuccessful">if set to <c>true</c> the response indicates a successful request.</param>
        /// <param name="messages">The messages related to the response (if any).</param>
        public ServiceResponse(T data, bool isSuccessful, ResponseMessageList messages)
            : this(data, isSuccessful, messages, DateTime.Now)
        {
        }

        /// <summary>
        /// Initialises a new instance of the <see cref="ServiceResponse{T}"/> class.
        /// </summary>
        /// <param name="data">The data of the response (may be null).</param>
        /// <param name="isSuccessful">if set to <c>true</c> the response indicates a successful request.</param>
        /// <param name="messages">The messages related to the response (if any).</param>
        /// <param name="receiptTimestamp">The date and time the response was received.</param>
        public ServiceResponse(T data, bool isSuccessful, ResponseMessageList messages, DateTime receiptTimestamp)
        {
            this.Data = data;
            this.IsSuccessful = isSuccessful;
            this.Messages = messages;
            this.ReceiptTimestamp = receiptTimestamp;
        }
    }
}