using HIPS.Client.Proxy;
using HIPS.CommonSchemas;
using HIPS.HpiiSchemas;
using HIPS.Web.Components.ServiceModel;
using HIPS.Web.ModelInterface.HpiiSearch;

namespace HIPS.Web.Data.Hips.HpiiSearch
{
    /// <summary>
    /// Defines the implementation of the Hpii Search Service interface.
    /// </summary>
    public class HpiiSearchService : IHpiiSearchService
    {
        private HpiiProxy proxy = new HpiiProxy("HpiiEndPoint");

        /// <summary>
        /// Performs an HPI-I search against the HI Service.
        /// </summary>
        /// <param name="query">The HPII identifier query.</param>
        /// <param name="user">Current user details.</param>
        /// <returns>Found HPI-I information</returns>
        public HpiiQueryResponse SearchByIdentifier(HpiiIdentifierQuery query, UserDetails operatingUser)
        {
            return proxy.HpiiValidation(query, operatingUser);
        }

        /// <summary>
        /// Performs an HPI-I Demographic query against the HPI-I Service.
        /// </summary>
        /// <param name="query">The HPII demographic query.</param>
        /// <param name="user">Current user details.</param>
        /// <returns>Found HPI-I information</returns>
        public HpiiQueryResponse SearchByDemographic(HpiiDemographicQuery query, UserDetails operatingUser)
        {
            return proxy.HpiiDemographicSearch(query, operatingUser);
        }

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            if (proxy != null)
            {
                proxy.DisposeSafely();
                proxy = null;
            }
        }
    }
}