﻿using AutoMapper;

using CommonSchema = HIPS.Web.Model;
using ServiceSchema = HIPS.ServiceContracts.Common.DTO;

namespace HIPS.Web.Data.Hips.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for user data.
    /// </summary>
    internal class UserIdentityProfile : Profile
    {
        public override string ProfileName
        {
            get
            {
                return this.GetType().Name;
            }
        }

        protected override void Configure()
        {
            this.CreateMap<CommonSchema.Identity.LocalUser, ServiceSchema.UserIdentity.LocalUser>()
                .ForMember(dest => dest.FamilyName, opt => opt.MapFrom(src => src.FamilyName))
                .ForMember(dest => dest.GivenNames, opt => opt.MapFrom(src => src.GivenNames))
                .ForMember(dest => dest.Login, opt => opt.MapFrom(src => src.Login))
                .ForMember(dest => dest.Domain, opt => opt.MapFrom(src => src.Domain));
        }
    }
}