﻿using System.Linq;
using System.Reflection;
using System.ServiceModel;

using HIPS.Web.Components.ServiceModel;

namespace HIPS.Web.Data.P2P.Service
{
    /// <summary>
    /// Provides a base class for services.
    /// </summary>
    /// <typeparam name="TClientProxy">The type of the client proxy</typeparam>
    public abstract class ServiceBase<TClientProxy> where TClientProxy : ICommunicationObject
    {
        #region Properties

        /// <summary>
        /// Gets or sets the client proxy used by the service.
        /// </summary>
        protected TClientProxy ClientProxy { get; set; }

        #endregion

        #region Methods

        #region IDisposable

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            if (this.ClientProxy != null)
            {
                this.ClientProxy.DisposeSafely();
                this.ClientProxy = default(TClientProxy);
            }
        }

        #endregion

        #endregion
    }
}