﻿using System;
using System.Collections.Generic;

using HIPS.P2P.Service.Contract.Common;
using HIPS.P2P.Service.Contract.Messaging.Delivery.Message;
using HIPS.Web.Components.ServiceModel;
using HIPS.Web.Data.P2P.Mapping;
using HIPS.Web.ModelInterface.Subscription;

using CommonSchema = HIPS.Web.Model.Subscription;
using ServiceSchema = HIPS.P2P.Service.Contract.Common.DTO;
using HIPS.P2P.Service.Contract.Directory.ReferenceData.Message;

namespace HIPS.Web.Data.P2P.Service
{
    /// <summary>
    /// Defines the implementation of the Reference Data Service.
    /// </summary>
    public class ReferenceDataService : ServiceBase<HIPS.P2P.Client.Proxy.ReferenceDataProxy>, IReferenceDataService
    {
        #region Constructor

        /// <summary>
        /// Initialises a new instance of the <see cref="ReferenceDataService"/> class.
        /// </summary>
        public ReferenceDataService()
        {
            this.ClientProxy = new HIPS.P2P.Client.Proxy.ReferenceDataProxy("ReferenceDataEndPoint");
        }

        #endregion

        #region Methods

        public ServiceResponse<List<CommonSchema.ReferenceItem>> Search(string referenceSetUri, string codePattern, string displayNamePattern, Model.Identity.LocalUser userContext)
        {
            ResponseMessageList messages = new ResponseMessageList();
            bool isSuccessful = false;

            try
            {
                var request = new SearchRequest()
                {
                    ReferenceSetUri = referenceSetUri,
                    CodePattern = codePattern,
                    DisplayNamePattern = displayNamePattern,
                    User = ObjectMapper.Map<ServiceSchema.UserIdentity.LocalUser>(userContext)
                };

                var result = this.ClientProxy.Search(request);
                // HIPS Status should be OK
                isSuccessful = result.Status == ResponseStatus.OK;

                // Add HIPS messages
                messages.AddRange(ObjectMapper.Map<List<ResponseMessage>>(result.Messages));

                return new ServiceResponse<List<CommonSchema.ReferenceItem>>(ObjectMapper.Map<List<CommonSchema.ReferenceItem>>(result.Data), isSuccessful, messages, DateTime.Now);
            }
            catch (Exception ex)
            {
                isSuccessful = false;

                // Add HIPS messages
                messages.AddRange(ObjectMapper.Map<List<ResponseMessage>>(ex));

                return new ServiceResponse<List<CommonSchema.ReferenceItem>>(null, isSuccessful, messages, DateTime.Now);
            }
        }

        #endregion
    }
}
