using System.Data.Entity;

using HIPS.Web.Model.AssistedRegistration;
using HIPS.Web.Model.Common;
using HIPS.Web.Model.Hpii;
using HIPS.Web.Model.Subscription;

namespace HIPS.Web.Data.WebsiteDb
{
    internal class WebsiteDbContext : DbContext
    {
        public WebsiteDbContext()
            : base("name=WebsiteDbContext")
        {
            // Set initializer to null to disable automatic DB creation
            Database.SetInitializer<WebsiteDbContext>(null);
        }

        protected override void OnModelCreating(DbModelBuilder modelBuilder)
        {
            /* Assisted Registration entities */
            modelBuilder.Entity<IdentityVerificationMethod>().ToTable("IdentityVerificationMethod", "hipsui");
            modelBuilder.Entity<IndigenousStatus>().ToTable("IndigenousStatus", "hipsui");
            modelBuilder.Entity<IvcDeliveryMethod>().ToTable("IvcDeliveryMethod", "hipsui");
            modelBuilder.Entity<MedicareConsent>().ToTable("MedicareConsent", "hipsui");
            modelBuilder.Entity<Sex>().ToTable("Sex", "hipsui");

            /* Subscription Maintenance entities */
            modelBuilder.Entity<ProximityRadius>().ToTable("ProximityRadius", "hipsui");

            // Discharge Summary entities
            modelBuilder.Entity<ClinicalSpecialty>().ToTable("ClinicalSpecialty", "hipsui");

            // HpiiSearch entities
            modelBuilder.Entity<Title>().ToTable("Title", "hipsui");
            modelBuilder.Entity<Suffix>().ToTable("Suffix", "hipsui");

            /* General entities */
            modelBuilder.Entity<Setting>().ToTable("Setting", "hipsui");
        }

        /* Assisted Registration entities */

        public DbSet<IdentityVerificationMethod> IdentityVerificationMethods { get; set; }

        public DbSet<IndigenousStatus> IndigenousStatuses { get; set; }

        public DbSet<IvcDeliveryMethod> IvcDeliveryMethods { get; set; }

        public DbSet<MedicareConsent> MedicareConsents { get; set; }

        public DbSet<Sex> Sexes { get; set; }

        public DbSet<ClinicalSpecialty> ClinicalSpecialties { get; set; }        
        
        public DbSet<Title> Titles { get; set; }
        
        public DbSet<Suffix> Suffixes { get; set; }

        /* Subscription Maintenance entities */

        public DbSet<ProximityRadius> ProximityRadiuses { get; set; }

        /* General entities */

        public DbSet<Setting> Settings { get; set; }
    }
}