﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.Model.Subscription;
using HIPS.Web.Model.AssistedRegistration;

namespace HIPS.Web.Model.Directory.Search
{
    public class ProviderIndividualSearch
    {
        #region Properties

        /// <summary>
        /// Gets or sets the sex of the individual.
        /// </summary>
        public Sex Sex { get; set; }

        /// <summary>
        /// Gets or sets the date of birth of the individual.
        /// </summary>        
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the provider identifier, which can be a national or local identifier.
        /// </summary>        
        public ProviderIdentifierSearch Identifier { get; set; }

        /// <summary>
        /// Gets or sets the individual name.
        /// </summary>        
        public IndividualNameSearch Name { get; set; }

        /// <summary>
        /// Gets or sets the electronic contact detail.
        /// </summary>        
        public ElectronicContactSearch Contact { get; set; }

        /// <summary>
        /// Gets or sets the provider type, specialty and/or specialisation.
        /// </summary>        
        public IndividualOccupation Classifications { get; set; }

        #endregion
    }
}
