﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Subscription
{
    public class ChannelType
    {
        #region Properties

        /// <summary>
        /// Gets or sets the NHSD URI for the channel type.
        /// </summary>
        public string ChannelTypeUri { get; set; }

        /// <summary>
        /// Gets or sets the NHSD Code for this channel type.
        /// </summary>        
        public string ChannelTypeCode { get; set; }

        /// <summary>
        /// Gets or sets the NHSD Description for this channel type.
        /// </summary>        
        public string ChannelTypeDescription { get; set; }

        /// <summary>
        /// Gets or sets, if applicable, a list of messaging vendors through
        /// which the provider location can receive documents over this channel.
        /// Examples are Argus, HealthLink or Medical Objects.
        /// Not applicable for fax or post.
        /// </summary>
        public List<ChannelCarrier> ChannelCarriers { get; set; }

        /// <summary>
        /// Gets or sets the degree to which the provider location prefers this
        /// channel to other channels for the same document type.
        /// </summary>
        public long Preference { get; set; }

        /// <summary>
        /// Gets or sets the NHSD Uri for the format in which the document must be sent when delivering using channel type.
        /// </summary>        
        public string DocumentFormatUri { get; set; }

        /// <summary>
        /// Gets or sets the NHSD Display name for the format in which the document must be sent when delivering using channel type.
        /// </summary>        
        public string DocumentFormatDisplayName { get; set; }

        /// <summary>
        /// Gets or sets the Payload Scheme URI for the 
        /// format in which the document must be sent when delivering using this channel type. 
        /// </summary>        
        public string PayloadScheme { get; set; }

        #endregion
    }
}
