﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.Model.Directory;

namespace HIPS.Web.Model.Subscription
{
    public class InteractionRecord
    {
        #region Properties

        /// <summary>
        /// Gets or sets the primary identifier of the target organisation.
        /// </summary>
        public string OrganisationId { get; set; }

        /// <summary>
        /// Gets or sets the payload scheme associated with the interaction record.
        /// </summary>
        public PayloadScheme PayloadScheme { get; set; }

        /// <summary>
        /// Gets or sets the delegate associated with the interaction record.
        /// </summary>
        public HIPS.Web.Model.Directory.Delegate Delegate { get; set; }

        /// <summary>
        /// Gets or sets the service interface associated with the interaction record.
        /// </summary>
        public ServiceInterface ServiceInterface { get; set; }

        /// <summary>
        /// Gets or sets the service endpoint URI associated with the interaction record.
        /// </summary>
        public string ServiceEndpointUri { get; set; }

        #endregion
    }
}
