﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Subscription
{
    public class ProviderLocation
    {
        #region Properties

        /// <summary>
        /// Gets or sets the list of identifiers for this location, including national and local identifiers.
        /// </summary>
        public List<ProviderLocationIdentifier> Identifiers { get; set; }

        /// <summary>
        /// Gets or sets the primary identifier of this location.
        /// </summary>        
        public string LocationId { get; set; }

        /// <summary>
        /// Gets or sets the primary identifier of the organisation to which this location belongs.
        /// </summary>
        public string OrganisationId { get; set; }

        /// <summary>
        /// Gets or sets the list of organisation types, service types and service units.
        /// </summary>
        public List<LocationClassification> Classifications { get; set; }

        /// <summary>
        /// Gets or sets the list of addresses.
        /// </summary>
        public List<Address> Addresses { get; set; }

        /// <summary>
        /// Gets or sets the list of electronic contact details.
        /// </summary>
        public List<ElectronicContact> Contacts { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the location description.
        /// </summary>
        public string LocationDescription { get; set; }

        #endregion
    }
}
