﻿using System.Collections.Generic;
using System.Linq;
using HIPS.Web.Model.AssistedRegistration;

namespace HIPS.Web.ModelInterface.AssistedRegistration
{
    public static class IAssistedRegistrationReferenceRepositoryExtensions
    {
        /// <summary>
        /// Returns Medicare Consent options in an ordered nested parent/child format up to one level of depth.
        /// Each Key represents a top-level Medicare Option, which may have zero or more nested child elements in the Value list.
        /// Nesting is only supported for one level of depth (children of children will be ignored).
        /// </summary>
        /// <returns>Medicare Consent options where each Key is a top-level option,
        /// with the Value list representing zero or more nested child options</returns>
        public static Dictionary<MedicareConsent, List<MedicareConsent>> GetMedicareConsentsNested(this IAssistedRegistrationReferenceRepository repository)
        {
            // Get all consent options
            List<MedicareConsent> consents = repository.GetMedicareConsents();

            // Return ordered nested dictioanry
            return consents
                .Where(c => c.ParentMedicareConsentId != null)
                .OrderBy(c => c.DisplayOrder)
                .ToDictionary(
                    c => c,
                    c => consents
                        .Where(ic => ic.ParentMedicareConsentId == c.ParentMedicareConsentId)
                        .OrderBy(ic => ic.DisplayOrder).ToList());
        }
    }
}