﻿using System;
using System.Collections.Generic;

using HIPS.Web.Model.Common;

namespace HIPS.Web.ModelInterface.DischargeSummary
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of a cached discharge summary reference repository.
    /// </summary>
    public interface IDischargeSummaryReferenceRepository : IDisposable
    {
        /// <summary>
        /// Gets all clinical specialties.
        /// </summary>
        /// <returns>List of Clinical Specialties.</returns>
        List<ClinicalSpecialty> GetClinicalSpecialties();
    }
}