﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.Components.ServiceModel;
using HIPS.Web.Model.Identity;
using HIPS.Web.Model.Messaging;

namespace HIPS.Web.ModelInterface.Messaging
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of a Message Receipt Service.
    /// </summary>
    public interface IMessageReceiptService
    {
        /// <summary>
        /// Returns a list of inbound sealed messages.
        /// </summary>
        /// <param name="sender">Sender of the inbound sealed message to be return.</param>
        /// <param name="receiver">Receiver of the inbound sealed message to be return.</param>
        /// <param name="receiptPeriod">Start/End of the inbound sealed message to be return.</param>
        /// <param name="messageStatusId">Message status Id of inbound sealed message to be return.</param>        
        /// <param name="documentType">Document type of the inbound sealed message to be return.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>
        ServiceResponse<List<InboundSealedMessage>> QueryMessages(MessageAddressee sender, MessageAddressee receiver, DateTimeRange receiptPeriod, int? messageStatusId, string documentType, LocalUser userContext, int recordLimit, int recordSkipFrom);

        /// <summary>
        /// Aborts a specified inbound message.
        /// </summary>
        /// <param name="invocationIdentifier">Identifier of the inbound message.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>
        ServiceResponse<object> AbortResponse(string invocationIdentifier, LocalUser userContext);

        /// <summary>
        /// Retries a specified inbound message.
        /// </summary>
        /// <param name="invocationIdentifier">Identifier of the inbound message.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>
        ServiceResponse<object> RetryResponse(string invocationIdentifier, LocalUser userContext);

        /// <summary>
        /// Removes a specified inbound message.
        /// </summary>
        /// <param name="invocationIdentifier">Identifier of the inbound message.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>
        ServiceResponse<object> RemoveMessage(string invocationIdentifier, LocalUser userContext);

        /// <summary>
        /// Downloads the message content of the specified inbound message.
        /// </summary>
        /// <param name="invocationIdentifier">Identifier of the inbound message.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>
        ServiceResponse<BinaryMessageContent> GetMessage(string invocationIdentifier, LocalUser userContext);

        /// <summary>
        /// Downloads the CDA message content of the specified inbound message.
        /// </summary>
        /// <param name="invocationIdentifier">Identifier of the inbound message.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>
        ServiceResponse<CdaMessageContent> GetCdaMessage(string invocationIdentifier, LocalUser userContext);
    }
}
