﻿using System;
using HIPS.PcehrSchemas;
using HIPS.Web.Components.ServiceModel;
using HIPS.ServiceContracts.Pcehr.Message;
using HIPS.ServiceContracts.Common.DTO.PatientIdentifier;
using HIPS.ServiceContracts.Common.DTO.UserIdentity;

namespace HIPS.Web.ModelInterface.PcehrView
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of a PCEHR viewing repository.
    /// </summary>
    public interface IPcehrServiceV2Repository : IDisposable
    {
        #region Methods

        /// <summary>
        /// Retrieves details of the patient's PCEHR status.
        /// </summary>
        /// <param name="patientIdentifier">Identifier for the patient.</param>
        /// <param name="operatingUser">User requesting the operation.</param>
        /// <returns>IsPcehrAdvertisedLocalResponse containing the results of the operation.</returns>
        ServiceResponse<IsPcehrAdvertisedLocalResponse> IsPcehrAdvertisedLocal(Mrn patientIdentifier, UserBase operatingUser);

        #endregion Methods
    }
}