﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.Components.ServiceModel;
using HIPS.Web.Model.Identity;
using HIPS.Web.Model.Subscription;

namespace HIPS.Web.ModelInterface.Subscription
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of a Subscription Service.
    /// </summary>
    public interface ISubscriptionService
    {
        #region Methods

        /// <summary>
        /// Searches the NHSD for provider individuals.
        /// </summary>
        /// <param name="request">Request message.</param>
        /// <returns>Response message.</returns>
        ServiceResponse<SearchResult> FindIndividuals(string familyName, string givenName, string occupation, string suburb, string state, string postCode, int proximityRadius, Model.Identity.LocalUser userContext);

        /// <summary>
        /// Searches the NHSD for provider organisations.
        /// </summary>
        /// <param name="request">Request message.</param>
        /// <returns>Response message.</returns>
        ServiceResponse<SearchResult> FindOrganisations(string organisationName, string classificaiton, string suburb, string state, string postCode, int proximityRadius, Model.Identity.LocalUser userContext);

        /// <summary>
        /// List of Area of Interest definitions.
        /// </summary>
        /// <param name="request">Request message.</param>
        /// <returns>Response message.</returns>
        ServiceResponse<List<AreaOfInterest>> ListSubscriptionDefinitions(Model.Identity.LocalUser userContext);

        /// <summary>
        /// Updates an Area of Interest definition to the accessing organisation’s subscription.
        /// </summary>
        /// <param name="request">Request message.</param>
        /// <returns>Response message.</returns>
        ServiceResponse<AreaOfInterest> UpdateAreaOfInterest(AreaOfInterest areaOfInterest, Model.Identity.LocalUser userContext);

        /// <summary>
        /// Adds an Area of Interest definition to the accessing organisation’s subscription.
        /// </summary>
        /// <param name="request">Request message.</param>
        /// <returns>Response message.</returns>
        ServiceResponse<AreaOfInterest> AddAreaOfInterest(AreaOfInterest areaOfInterest, Model.Identity.LocalUser userContext);

        //// <summary>
        /// Deletes an Area of Interest definition from the accessing organisation’s subscription.
        /// </summary>
        /// <param name="request">Request message.</param>
        /// <returns>Response message.</returns>
        ServiceResponse<AreaOfInterest> DeleteAreaOfInterest(AreaOfInterest areaOfInterest, Model.Identity.LocalUser userContext);

        #endregion
    }
}
