﻿using System.Web.Mvc;

namespace HIPS.Web.UI.Areas.Messaging
{
    /// <summary>
    /// Messaging Area Registration.
    /// </summary>
    public class MessagingAreaRegistration : AreaRegistration
    {
        #region Properties
        
        /// <summary>
        /// Gets the name of the area.
        /// </summary>
        public override string AreaName
        {
            get
            {
                return "Messaging";
            }
        }

        #endregion
        
        #region Methods
        
        /// <summary>
        /// Register the area.
        /// </summary>
        /// <param name="context">AreaRegistrationContext to use for registration of the area.</param>
        public override void RegisterArea(AreaRegistrationContext context)
        {
            context.MapRoute(
                "Messaging_default",
                "Messaging/{controller}/{action}/{id}",
                new { action = "Index", id = UrlParameter.Optional });
        }

        #endregion
    }
}
