﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

using HIPS.Web.Model;

namespace HIPS.Web.UI.Areas.Messaging.ViewModels
{
    /// <summary>
    /// View model for displaying the result when searching inbound sealed messages.
    /// </summary>
    public class ListReceiptViewModel
    {
        /// <summary>
        /// Gets or sets the Invocation Identifier.
        /// </summary>
        [Display(Name = "Invocation Identifier")]
        public string InvocationIdentifier { get; set; }
        
        /// <summary>
        /// Gets or sets the Message Timestamp.
        /// </summary>
        [Display(Name = "Received")]
        public DateTime MessageTimestamp { get; set; }

        /// <summary>
        /// Gets or sets the Sender.
        /// </summary>
        [Display(Name = "Sender HPI-O")]
        public string Sender { get; set; }
        
        /// <summary>
        /// Gets or sets the Document Type.
        /// </summary>
        [Display(Name = "Document Type")]
        public string DocumentType { get; set; }
        
        /// <summary>
        /// Gets or sets the Message Status.
        /// </summary>
        [Display(Name = "Message Status")]
        public InboundMessageStatus MessageStatus { get; set; }

        /// <summary>
        /// Gets or sets additional details.
        /// </summary>
        public DetailsViewModel Details { get; set; }
    }
}