﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.Areas.Messaging.ViewModels
{
    /// <summary>
    /// Base view model to be used with the Messaging feature.
    /// </summary>
    public abstract class MessagingBaseViewModel
    {
        /// <summary>
        /// Gets or sets From date.
        /// </summary>
        [Required]
        public DateTime From { get; set; }

        /// <summary>
        /// Gets or sets To date.
        /// </summary>
        [Required]
        public DateTime To { get; set; }
        
        /// <summary>
        /// Gets or sets the Message Status Id.
        /// </summary>
        [Display(Name = "Status")]
        public int? MessageStatusId { get; set; }

        /// <summary>
        /// Gets or sets the Document type code.
        /// </summary>
        [Display(Name = "Document Type")]
        public string DocumentTypeCode { get; set; }
        
        /// <summary>
        /// Gets or sets the list of message statuses available for selection.
        /// </summary>
        public IEnumerable<SelectListItem> MessageStatuses { get; set; }        
        
        /// <summary>
        /// Gets or sets the list of document types available for selection.
        /// </summary>
        public IEnumerable<SelectListItem> DocumentTypes { get; set; }
        
        /// <summary>
        /// Gets or sets the list of messages associated with the view model.
        /// </summary>        
        public ViewMessageList Messages { get; set; }
    }
}