﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.Areas.Subscription.ViewModels
{
    public class ExtraIndividualSearchViewModel
    {
        #region Properties

        /// <summary>
        /// Gets or sets Family Name.
        /// </summary>
        [Display(Name = "Family Name")]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the Given Name.
        /// </summary>
        [Display(Name = "Given Name")]
        public string GivenName { get; set; }

        /// <summary>
        /// Gets or sets the Occupation.
        /// </summary>
        public string Occupation { get; set; }

        /// <summary>
        /// Gets or sets the Occupation list for the dropdown.
        /// </summary>
        public IEnumerable<SelectListItem> OccupationList { get; set; }

        /// <summary>
        /// Gets or sets the Suburb.
        /// </summary>
        public string Suburb { get; set; }

        /// <summary>
        /// Gets or sets the State.
        /// </summary>
        public string State { get; set; }

        /// <summary>
        /// Gets or sets the State List for the dropdown.
        /// </summary>
        public IEnumerable<SelectListItem> StateList { get; set; }

        /// <summary>
        /// Gets or sets the Postcode.
        /// </summary>
        public string Postcode { get; set; }

        /// <summary>
        /// Gets or sets the ProximityRadius.
        /// </summary>
        [Display(Name = "Proximity Radius")]
        public int ProximityRadius { get; set; }

        /// <summary>
        /// Gets or sets the ProximityRadius List for the dropdown.
        /// </summary>
        public IEnumerable<SelectListItem> ProximityRadiusList { get; set; }

        /// <summary>
        /// Gets or sets the URI allocated by NEPS to identify this area of interest definition.
        /// </summary>
        public string IndiCode { get; set; }

        #endregion
    }
}
