﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;
using System.Web;
using System.Web.Mvc;
using Microsoft.AspNet.Identity;
using Microsoft.AspNet.Identity.EntityFramework;
using Microsoft.Owin.Security;
using HIPS.Web.UI.ViewModels.Account;
using System.Web.UI;

namespace HIPS.Web.UI.Controllers
{
    [Authorize]
    public partial class RoleController : Controller
    {

        public RoleController()
            : this(new RoleManager<IdentityRole>(new RoleStore<IdentityRole>(new ApplicationDbContext())))
        {
        }

        public RoleController(RoleManager<IdentityRole> roleManager)
        {
            RoleManager = roleManager;
               
        }

        public RoleManager<IdentityRole> RoleManager { get; private set; }

        // GET: /Roles/Create
        public ActionResult Create()
        {
            return View();
        }

        //
        // POST: /Roles/Create
        [HttpPost]
        public ActionResult Create(FormCollection collection)
        {
            try
            {
                if (!RoleManager.RoleExists(collection["RoleName"]))
                {
                    RoleManager.Create(new IdentityRole(collection["RoleName"]));
                    ViewBag.ResultMessage = "Role created successfully !";
                    return RedirectToAction("Index");

                }
                else
                {
                    ViewBag.ErrorMessage = "Role already exists.";
                    return View();
                }
            }
            catch
            {
                return View();
            }
        }
        

        public ActionResult Index()
        {
            var roles = RoleManager.Roles.ToList();
            return View(roles);
        }

        public ActionResult Delete(string RoleName)
        {
            try
            {
            var thisRole = RoleManager.Roles.Where(r => r.Name.Equals(RoleName, StringComparison.CurrentCultureIgnoreCase)).FirstOrDefault();
            RoleManager.Delete(thisRole);

            return RedirectToAction("Index");
            }
            catch
            {
                ViewBag.ErrorMessage = "Role could not be deleted.";
                return View();
            }
        }

        //
        // GET: /Role/Edit/5
        public ActionResult Edit(string roleName)
        {
            var thisRole = RoleManager.Roles.Where(r => r.Name.Equals(roleName, StringComparison.CurrentCultureIgnoreCase)).FirstOrDefault();

            return View(thisRole);
        }

        //
        // POST: /Role/Edit/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit(Microsoft.AspNet.Identity.EntityFramework.IdentityRole role)
        {
            try
            {
                RoleManager.Update(role);

                return RedirectToAction("Index");
            }
            catch
            {
                ViewBag.ErrorMessage = "Role could not be updated.";
                return View();
            }
        }

        public ActionResult ManageUserRoles()
        {
            // prepopulate roles for the view dropdown
            var list = RoleManager.Roles.OrderBy(r => r.Name).ToList().Select(rr =>

            new SelectListItem { Value = rr.Name.ToString(), Text = rr.Name }).ToList();
            ViewBag.Roles = list;
            return View();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult RoleAddToUser(string UserName, string RoleName)
        {
            
            var account = new AccountController();
            ApplicationUser user = account.UserManager.Users.Where(u => u.UserName.Equals(UserName, StringComparison.CurrentCultureIgnoreCase)).FirstOrDefault();

            if (user == null)
                ViewBag.ErrorMessage = string.Format("A user with the user name {0} does not exist.", UserName);
            if (string.IsNullOrEmpty(RoleName))
                ViewBag.ErrorMessage = "Please select a Role to add the User to.";

            if (user != null && !string.IsNullOrEmpty(RoleName) && !account.UserManager.IsInRole(user.Id, RoleName))
            {
                account.UserManager.AddToRole(user.Id, RoleName);
                ViewBag.ResultMessage = "Role created successfully !";
            }
            

            // prepopulate roles for the view dropdown
            var roles = RoleManager.Roles.OrderBy(r => r.Name).ToList().Select(rr => new SelectListItem { Value = rr.Name.ToString(), Text = rr.Name }).ToList();
            ViewBag.Roles = roles;

            return View("ManageUserRoles");
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult GetRoles(string UserName)
        {
            if (!string.IsNullOrWhiteSpace(UserName) && !string.IsNullOrEmpty(UserName))
            {
                var account = new AccountController();
                ApplicationUser user = account.UserManager.Users.Where(u => u.UserName.Equals(UserName, StringComparison.CurrentCultureIgnoreCase)).FirstOrDefault();
                if (user != null)
                    ViewBag.RolesForThisUser = account.UserManager.GetRoles(user.Id);
                else
                    ViewBag.ErrorMessage = string.Format("A user with the user name {0} does not exist.", UserName);

                // prepopulat roles for the view dropdown
                var list = RoleManager.Roles.OrderBy(r => r.Name).ToList().Select(rr => new SelectListItem { Value = rr.Name.ToString(), Text = rr.Name }).ToList();
                ViewBag.Roles = list;
            }
            else
                ViewBag.ErrorMessage = string.Format("A user name is required.", UserName);

            return View("ManageUserRoles");
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult DeleteRoleForUser(string UserName, string RoleName)
        {
            var account = new AccountController();
            ApplicationUser user = account.UserManager.Users.Where(u => u.UserName.Equals(UserName, StringComparison.CurrentCultureIgnoreCase)).FirstOrDefault();

            if (user == null)
                ViewBag.ErrorMessage = string.Format("User with user name {0} does not exist.", UserName);
            if (string.IsNullOrEmpty(RoleName))
                ViewBag.ErrorMessage = "Please select a Role to remove the User from.";
            if (user != null && !string.IsNullOrEmpty(RoleName) && !account.UserManager.IsInRole(user.Id, RoleName))
                ViewBag.ErrorMessage = string.Format("User with user name {0} is not in selected {1} Role.", UserName, RoleName);

            if (user != null && !string.IsNullOrEmpty(RoleName) && account.UserManager.IsInRole(user.Id, RoleName))
            {
                account.UserManager.RemoveFromRole(user.Id, RoleName);
                ViewBag.ResultMessage = string.Format("{0} Role removed from {1} user successfully !", RoleName, UserName);
            }
            

            // prepopulat roles for the view dropdown
            var roles = RoleManager.Roles.OrderBy(r => r.Name).ToList().Select(rr => new SelectListItem { Value = rr.Name.ToString(), Text = rr.Name }).ToList();
            ViewBag.Roles = roles;

            return View("ManageUserRoles");
        }
    }
}